/*
 * Decompiled with CFR 0.152.
 */
package jacorb.idl;

import jacorb.idl.ConstrTypeSpec;
import jacorb.idl.Declarator;
import jacorb.idl.IRMap;
import jacorb.idl.IdlSymbol;
import jacorb.idl.Member;
import jacorb.idl.MemberList;
import jacorb.idl.NameAlreadyDefined;
import jacorb.idl.NameTable;
import jacorb.idl.Scope;
import jacorb.idl.ScopeData;
import jacorb.idl.ScopedName;
import jacorb.idl.TypeDeclaration;
import jacorb.idl.TypeMap;
import jacorb.idl.TypeSpec;
import jacorb.idl.parser;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;

class StructType
extends TypeDeclaration
implements Scope {
    private boolean written = false;
    public boolean exc;
    public MemberList memberlist = null;
    private boolean parsed = false;
    private ScopeData scopeData;

    public StructType(int n) {
        super(n);
        this.pack_name = "";
    }

    public boolean basic() {
        return false;
    }

    public String className() {
        String string;
        String string2 = this.typeName();
        if (string2.indexOf(46) > 0) {
            this.pack_name = string2.substring(0, string2.lastIndexOf(46));
            string = string2.substring(string2.lastIndexOf(46) + 1);
        } else {
            this.pack_name = "";
            string = string2;
        }
        return string;
    }

    public Object clone() {
        StructType structType = new StructType(IdlSymbol.new_num());
        structType.pack_name = this.pack_name;
        structType.name = this.name;
        structType.memberlist = this.memberlist;
        structType.included = this.included;
        structType.token = this.token;
        structType.exc = this.exc;
        structType.scopeData = this.scopeData;
        return structType;
    }

    public TypeDeclaration declaration() {
        return this;
    }

    public ScopeData getScopeData() {
        return this.scopeData;
    }

    public String getTypeCodeExpression() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("org.omg.CORBA.ORB.init().create_struct_tc(id(),\"" + this.className() + "\",");
        if (this.memberlist != null) {
            stringBuffer.append("new org.omg.CORBA.StructMember[]{");
            Enumeration enumeration = this.memberlist.v.elements();
            while (enumeration.hasMoreElements()) {
                Member member = (Member)enumeration.nextElement();
                Declarator declarator = member.declarator;
                stringBuffer.append("new org.omg.CORBA.StructMember(\"" + declarator.name() + "\",");
                stringBuffer.append(String.valueOf(member.type_spec.typeSpec().getTypeCodeExpression()) + ",null)");
                if (!enumeration.hasMoreElements()) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append("}");
        } else {
            stringBuffer.append("new org.omg.CORBA.StructMember[0]");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String holderName() {
        return String.valueOf(this.typeName()) + "Holder";
    }

    public void parse() {
        if (this.parsed) {
            throw new RuntimeException("Compiler error: Struct already parsed!");
        }
        this.escapeName();
        try {
            ScopedName.definePseudoScope(this.full_name());
            ConstrTypeSpec constrTypeSpec = new ConstrTypeSpec(IdlSymbol.new_num());
            constrTypeSpec.c_type_spec = this;
            NameTable.define(this.full_name(), "type");
            TypeMap.typedef(this.full_name(), constrTypeSpec);
        }
        catch (NameAlreadyDefined nameAlreadyDefined) {
            parser.error("Struct " + this.typeName() + " already defined", this.token);
        }
        if (this.memberlist != null) {
            this.memberlist.parse();
        }
        this.parsed = true;
    }

    public void print(PrintWriter printWriter) {
        if (this.included && !this.generateIncluded()) {
            return;
        }
        if (this.written) {
            return;
        }
        this.written = true;
        try {
            String string = this.className();
            String string2 = String.valueOf(parser.out_dir) + IdlSymbol.fileSeparator + this.pack_name.replace('.', IdlSymbol.fileSeparator);
            File file = new File(string2);
            if (!file.exists() && !file.mkdirs()) {
                System.err.println("Unable to create " + string2);
                System.exit(1);
            }
            String string3 = String.valueOf(string) + ".java";
            PrintWriter printWriter2 = new PrintWriter(new FileWriter(new File(file, string3)));
            this.printStructClass(string, printWriter2);
            printWriter2.close();
            string3 = String.valueOf(string) + "Holder.java";
            printWriter2 = new PrintWriter(new FileWriter(new File(file, string3)));
            this.printHolderClass(string, printWriter2);
            printWriter2.close();
            string3 = String.valueOf(string) + "Helper.java";
            printWriter2 = new PrintWriter(new FileWriter(new File(file, string3)));
            this.printHelperClass(string, printWriter2);
            printWriter2.close();
            IRMap.enter(this);
            this.written = true;
        }
        catch (IOException iOException) {
            System.err.println("File IO error");
            iOException.printStackTrace();
        }
    }

    private void printHelperClass(String string, PrintWriter printWriter) {
        Declarator declarator;
        Member member;
        Enumeration enumeration;
        if (!this.pack_name.equals("")) {
            printWriter.println("package " + this.pack_name + ";");
        }
        printWriter.println("public class " + string + "Helper");
        printWriter.println("{");
        printWriter.println("\tprivate static org.omg.CORBA.TypeCode _type = " + this.getTypeCodeExpression() + ";");
        String string2 = this.typeName();
        printWriter.println("\tpublic " + string + "Helper ()");
        printWriter.println("\t{");
        printWriter.println("\t}");
        TypeSpec.printHelperClassMethods(string, printWriter, string2);
        this.printIdMethod(printWriter);
        printWriter.println("\tpublic static " + string2 + " read(org.omg.CORBA.portable.InputStream in)");
        printWriter.println("\t{");
        printWriter.println("\t\t" + string2 + " result = new " + string2 + "();");
        if (this.exc) {
            printWriter.println("\t\tif(!in.read_string().equals(id())) throw new org.omg.CORBA.MARSHAL(\"wrong id\");");
        }
        if (this.memberlist != null) {
            enumeration = this.memberlist.v.elements();
            while (enumeration.hasMoreElements()) {
                member = (Member)enumeration.nextElement();
                declarator = member.declarator;
                printWriter.println("\t\t" + member.type_spec.typeSpec().printReadStatement("result." + declarator.name(), "in"));
            }
        }
        printWriter.println("\t\treturn result;");
        printWriter.println("\t}");
        printWriter.println("\tpublic static void write(org.omg.CORBA.portable.OutputStream out, " + string2 + " s)");
        printWriter.println("\t{");
        if (this.exc) {
            printWriter.println("\t\tout.write_string(id());");
        }
        if (this.memberlist != null) {
            enumeration = this.memberlist.v.elements();
            while (enumeration.hasMoreElements()) {
                member = (Member)enumeration.nextElement();
                declarator = member.declarator;
                printWriter.println(member.type_spec.typeSpec().printWriteStatement("s." + declarator.name(), "out"));
            }
        }
        printWriter.println("\t}");
        printWriter.println("}");
    }

    private void printHolderClass(String string, PrintWriter printWriter) {
        if (!this.pack_name.equals("")) {
            printWriter.println("package " + this.pack_name + ";");
        }
        printWriter.println("final public class " + string + "Holder");
        printWriter.println("\timplements org.omg.CORBA.portable.Streamable");
        printWriter.println("{");
        printWriter.println("\tpublic " + this.typeName() + " value;\n");
        printWriter.println("\tpublic " + string + "Holder ()");
        printWriter.println("\t{");
        printWriter.println("\t}");
        printWriter.println("\tpublic " + string + "Holder (" + this.typeName() + " initial)");
        printWriter.println("\t{");
        printWriter.println("\t\tvalue = initial;");
        printWriter.println("\t}");
        printWriter.println("\tpublic org.omg.CORBA.TypeCode _type()");
        printWriter.println("\t{");
        printWriter.println("\t\treturn " + this.typeName() + "Helper.type();");
        printWriter.println("\t}");
        printWriter.println("\tpublic void _read(org.omg.CORBA.portable.InputStream _in)");
        printWriter.println("\t{");
        printWriter.println("\t\tvalue = " + this.typeName() + "Helper.read(_in);");
        printWriter.println("\t}");
        printWriter.println("\tpublic void _write(org.omg.CORBA.portable.OutputStream _out)");
        printWriter.println("\t{");
        printWriter.println("\t\t" + this.typeName() + "Helper.write(_out,value);");
        printWriter.println("\t}");
        printWriter.println("}");
    }

    public String printReadExpression(String string) {
        return String.valueOf(this.toString()) + "Helper.read(" + string + ")";
    }

    private void printStructClass(String string, PrintWriter printWriter) {
        String string2 = string;
        if (!this.pack_name.equals("")) {
            string2 = String.valueOf(this.pack_name) + "." + string;
            printWriter.println("package " + this.pack_name + ";");
        }
        printWriter.println("public final class " + string);
        if (this.exc) {
            printWriter.println("\textends org.omg.CORBA.UserException");
        } else {
            printWriter.println("\timplements org.omg.CORBA.portable.IDLEntity");
        }
        printWriter.println("{");
        if (this.memberlist != null) {
            Declarator declarator;
            IdlSymbol idlSymbol;
            Enumeration enumeration;
            Enumeration enumeration2;
            Enumeration enumeration3 = this.memberlist.v.elements();
            while (enumeration3.hasMoreElements()) {
                ((Member)enumeration3.nextElement()).member_print(printWriter, "\tpublic ");
                printWriter.println();
            }
            if (this.exc) {
                printWriter.println("\tpublic " + string + "()");
                printWriter.println("\t{");
                printWriter.println("\t\tsuper(" + string2 + "Helper.id());");
                printWriter.println("\t}");
            } else {
                printWriter.println("\tpublic " + string + "(){}");
            }
            if (this.exc) {
                printWriter.print("\tpublic " + string + "(");
                printWriter.print("java.lang.String _reason,");
                enumeration2 = this.memberlist.v.elements();
                while (enumeration2.hasMoreElements()) {
                    enumeration = (Member)enumeration2.nextElement();
                    idlSymbol = ((Member)((Object)enumeration)).declarator;
                    printWriter.print(String.valueOf(((Member)((Object)enumeration)).type_spec.toString()) + " " + ((Declarator)idlSymbol).toString());
                    if (!enumeration2.hasMoreElements()) continue;
                    printWriter.print(", ");
                }
                printWriter.println(")");
                printWriter.println("\t{");
                printWriter.println("\t\tsuper(" + string2 + "Helper.id()+\"\"+_reason );");
                enumeration = this.memberlist.v.elements();
                while (enumeration.hasMoreElements()) {
                    idlSymbol = (Member)enumeration.nextElement();
                    declarator = ((Member)idlSymbol).declarator;
                    printWriter.print("\t\tthis.");
                    printWriter.print(declarator.name());
                    printWriter.print(" = ");
                    printWriter.println(String.valueOf(declarator.name()) + ";");
                }
                printWriter.println("\t}");
            }
            printWriter.print("\tpublic " + string + "(");
            enumeration2 = this.memberlist.v.elements();
            while (enumeration2.hasMoreElements()) {
                enumeration = (Member)enumeration2.nextElement();
                idlSymbol = ((Member)((Object)enumeration)).declarator;
                printWriter.print(String.valueOf(((Member)((Object)enumeration)).type_spec.toString()) + " " + ((Declarator)idlSymbol).toString());
                if (!enumeration2.hasMoreElements()) continue;
                printWriter.print(", ");
            }
            printWriter.println(")");
            printWriter.println("\t{");
            enumeration = this.memberlist.v.elements();
            while (enumeration.hasMoreElements()) {
                idlSymbol = (Member)enumeration.nextElement();
                declarator = ((Member)idlSymbol).declarator;
                printWriter.print("\t\tthis.");
                printWriter.print(declarator.name());
                printWriter.print(" = ");
                printWriter.println(String.valueOf(declarator.name()) + ";");
            }
            printWriter.println("\t}");
        }
        printWriter.println("}");
    }

    public String printWriteStatement(String string, String string2) {
        return String.valueOf(this.toString()) + "Helper.write(" + string2 + "," + string + ");";
    }

    public void setEnclosingSymbol(IdlSymbol idlSymbol) {
        if (this.enclosing_symbol != null && this.enclosing_symbol != idlSymbol) {
            System.err.println("was " + this.enclosing_symbol.getClass().getName() + " now: " + idlSymbol.getClass().getName());
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        this.enclosing_symbol = idlSymbol;
    }

    public void setPackage(String string, boolean bl) {
        string = parser.pack_replace(string);
        this.pack_name = this.pack_name.length() > 0 ? new String(String.valueOf(string) + "." + this.pack_name) : string;
        if (this.memberlist != null) {
            this.memberlist.setPackage(string, bl);
        }
    }

    public void setScopeData(ScopeData scopeData) {
        this.scopeData = scopeData;
    }

    public void set_included(boolean bl) {
        this.included = bl;
    }

    public void set_memberlist(MemberList memberList) {
        memberList.setStruct(this);
        this.memberlist = memberList;
        this.memberlist.setPackage(this.name, true);
        if (this.memberlist != null) {
            this.memberlist.setEnclosingSymbol(this);
        }
    }

    public String signature() {
        return "L" + this.typeName() + ";";
    }

    public String toString() {
        return this.typeName();
    }

    public String typeName() {
        if (this.pack_name.length() > 0) {
            String string = ScopedName.unPseudoName(String.valueOf(this.pack_name) + "." + this.name);
            if (!string.startsWith("org.omg")) {
                return String.valueOf(this.omg_package_prefix) + string;
            }
            return string;
        }
        return ScopedName.unPseudoName(this.name);
    }
}

