// This snippet creates a new dialog box
// with buttons on the bottom.

//Title:
//Version:
//Copyright:
//Author:
//Company:
//Description:

package  jacorb.orb.domain.gui;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;

import jacorb.orb.ParsedIOR;
import jacorb.orb.util.PrintIOR;

/** This dialog box display properties of an org.omg.CORBA.Object. */

public class PropertyDialog extends JDialog {
  // handmade
  /** the object which properties are displayed */
  org.omg.CORBA.Object _object;

  JPanel RootPanel = new JPanel();
  JPanel MainPanel = new JPanel();
  JButton OkButton = new JButton();
  JButton CancelButton = new JButton();
  Border border1;
  JPanel ButtonPanel = new JPanel();
  GridBagLayout gridBagLayout1 = new GridBagLayout();
  JTabbedPane TabbedPane = new JTabbedPane();
  JScrollPane IORScrollPane = new JScrollPane();
  JPanel Panel = new JPanel();
  JPanel jPanel1 = new JPanel();
  JPanel LeftPanel = new JPanel();
  JPanel RightPanel = new JPanel();
  BorderLayout borderLayout1 = new BorderLayout();
  GridLayout gridLayout2 = new GridLayout();
  GridLayout gridLayout3 = new GridLayout();
  JLabel TypeIdLabel = new JLabel();
  JLabel HostLabel = new JLabel();
  JLabel TypeIdValueLabel = new JLabel();
  JLabel HostValueLabel = new JLabel();
  // JLabel PortLabel = new JLabel();
  JLabel ObjectKeyLabel = new JLabel();
  JLabel ObjectKeyValueLabel = new JLabel();
  // JLabel PortValueLabel = new JLabel();
  TitledBorder titledBorder1;
  GridLayout gridLayout4 = new GridLayout();
  Border border2;
  FlowLayout flowLayout1 = new FlowLayout();

  public PropertyDialog(org.omg.CORBA.Object obj,
                        Frame frame, String title, boolean modal) {
    super(frame, title, modal);

    try {
      jbInit();

      // do handmade initialization AFTER jbInit
       _object= obj;
      initIORPane(_object);
      this.setLocationRelativeTo(frame); // put dialog into center of parent
    }
    catch (Exception e) {
      e.printStackTrace();
    }

    pack();

  }

  public PropertyDialog(org.omg.CORBA.Object obj, Frame frame, String title) {
    this(obj, frame, title, false);
  }

  public PropertyDialog(org.omg.CORBA.Object obj, Frame frame) {
    this(obj, frame, "", false);
  }

  private void jbInit() throws Exception {
    border1 = BorderFactory.createRaisedBevelBorder();
    titledBorder1 = new TitledBorder("");
    border2 = BorderFactory.createEmptyBorder();
    ButtonPanel.setLayout(flowLayout1);
    MainPanel.setBorder(border1);
    MainPanel.setLayout(gridLayout4);
    OkButton.setText("OK");
    OkButton.addActionListener(new PropertyDialog_OkButton_actionAdapter(this));
    CancelButton.setEnabled(false);
    CancelButton.setBorder(BorderFactory.createEtchedBorder());
    CancelButton.setBorderPainted(false);
    CancelButton.addActionListener(new PropertyDialog_CancelButton_actionAdapter(this));
    this.addWindowListener(new PropertyDialog_this_windowAdapter(this));
    RootPanel.setLayout(gridBagLayout1);
    Panel.setLayout(borderLayout1);
    LeftPanel.setLayout(gridLayout2);
    RightPanel.setLayout(gridLayout3);
    TypeIdLabel.setHorizontalTextPosition(SwingConstants.LEFT);
    TypeIdLabel.setText("Type ID:");
    HostLabel.setText("Host:");
    gridLayout2.setColumns(1);
    gridLayout2.setRows(0);
    gridLayout3.setColumns(1);
    gridLayout3.setRows(0);
    TypeIdValueLabel.setText("null");
    HostValueLabel.setText("null");
    // PortLabel.setText("Port:");
    ObjectKeyLabel.setText("Object Key:");
    ObjectKeyValueLabel.setText("null");
    // PortValueLabel.setText("null");
    borderLayout1.setHgap(10);
    RootPanel.add(MainPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    MainPanel.add(TabbedPane, null);
    TabbedPane.add(IORScrollPane, "IOR");
    IORScrollPane.getViewport().add(Panel, null);
    Panel.add(LeftPanel, BorderLayout.WEST);
    LeftPanel.add(TypeIdLabel, null);
    LeftPanel.add(HostLabel, null);
    // LeftPanel.add(PortLabel, null);
    LeftPanel.add(ObjectKeyLabel, null);
    Panel.add(RightPanel, BorderLayout.CENTER);
    RightPanel.add(TypeIdValueLabel, null);
    RightPanel.add(HostValueLabel, null);
    // RightPanel.add(PortValueLabel, null);
    RightPanel.add(ObjectKeyValueLabel, null);
    RootPanel.add(ButtonPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(4, 8, 4, 8), 0, 0));
    ButtonPanel.add(OkButton, null);
    ButtonPanel.add(CancelButton, null);
    RootPanel.add(jPanel1, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    getContentPane().add(RootPanel);
}

  // OK
  void OkButton_actionPerformed(ActionEvent e) {
    dispose();
  }

  // Cancel
  void CancelButton_actionPerformed(ActionEvent e) {
    dispose();
  }

  void this_windowClosing(WindowEvent e) {
    dispose();
  }
  // *************** handmade additions ********************************
  /** initializes the labels of the IOR pane */
  // public void initIORPane()
  // {
  //  jacorb.util.Debug.assert(2, _object != null, "object is null");
  //  initIORPane(_object);
  // }

  /** initializes the labels of the IOR pane */
  public void initIORPane(org.omg.CORBA.Object obj)
  {

    ParsedIOR pior= new ParsedIOR( obj.toString() );
    org.omg.IOP.IOR ior= pior.getIOR();
    // extract values from ior/pior and put them into corresponding labels
    TypeIdValueLabel.setText(ior.type_id);
    HostValueLabel.setText(pior.getAddress());
    // PortValueLabel.setText(pior.getAddress());
    ObjectKeyValueLabel.setText(dumpHex(pior.get_object_key()));
  }  // initIORPane

  /** creates and returns a scrollable text pane.
   *  @param text the text the test pane is initialized with
   *  @return scrollpane the a newly created scrollpane which only component is
   *          a text pane holding the provided text
   */
  private static JScrollPane createScrollableTextPane(String text)
  {
    return null;
  } // create ScrollableTextPane

  /** converts an object key from byte to string. */
  public static String dumpHex(byte bs[])
  {
      String result= "";
	    for (int i=0; i<bs.length; i++)	{
		  int n1 = (bs[i] & 0xff) / 16;
		  int n2 = (bs[i] & 0xff) % 16;
		  char c1 = (char)(n1>9 ? ('A'+(n1-10)) : ('0'+n1));
		  char c2 = (char)(n2>9 ? ('A'+(n2-10)) : ('0'+n2));
		  result= result + c1 + (c2 + " ");
	  }
    return result;
  } // dumpHex

  /** adds a component to the tabbed pane at the end.
    * @param title the title to be display on the tab
    * @param comp the component to add
    */
  public Component add(String title, Component comp)
  {
    TabbedPane.addTab(title, comp);
    return comp;
  }

  /** adds a component to the tabbed pane at the specified index.
    * @param title the title to be display on the tab
    * @param comp the component to add
    * @param index the index where to add. A index of -1 means at the end of
    *              the components list.
    */
  public Component add(String title, Component comp, int index)
  {
    TabbedPane.insertTab(title, null, comp, title, index);
    return comp;
  }
} // PropertyDialog

class PropertyDialog_OkButton_actionAdapter implements ActionListener {
  PropertyDialog adaptee;

  PropertyDialog_OkButton_actionAdapter(PropertyDialog adaptee) {
    this.adaptee = adaptee;
  }

  public void actionPerformed(ActionEvent e) {
    adaptee.OkButton_actionPerformed(e);
  }
}

class PropertyDialog_CancelButton_actionAdapter implements ActionListener {
  PropertyDialog adaptee;

  PropertyDialog_CancelButton_actionAdapter(PropertyDialog adaptee) {
    this.adaptee = adaptee;
  }

  public void actionPerformed(ActionEvent e) {
    adaptee.CancelButton_actionPerformed(e);
  }
}

class PropertyDialog_this_windowAdapter extends WindowAdapter {
  PropertyDialog adaptee;

  PropertyDialog_this_windowAdapter(PropertyDialog adaptee) {
    this.adaptee = adaptee;
  }

  public void windowClosing(WindowEvent e) {
    adaptee.this_windowClosing(e);
  }
}

