/*
 *        JacORB - a free Java ORB
 *
 *   Copyright (C) 1997-98  Gerald Brose.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/**
 * @author Gerald Brose
 * @version 0.5, 28 January 1997
 */

package jacorb.idl;

import java.util.Vector;
import java.util.Enumeration;
import java.io.*;


class SymbolList 
	extends IdlSymbol
{
	public Vector v;

	public SymbolList(int num)
	{
		super(num);
		v = new Vector();
	}

    public void setPackage( String s, boolean propagate_into_included )
    {
        s = parser.pack_replace(s);
		if( pack_name.length() > 0  )
			pack_name = new String( s + "." + pack_name );
		else
			pack_name = s;
		Enumeration e = v.elements();
		for(; e.hasMoreElements(); )
			((IdlSymbol)e.nextElement()).setPackage(s, propagate_into_included);
	}

	public void parse() 
		 
	{
		Enumeration e = v.elements();
		for(; e.hasMoreElements(); )
			((IdlSymbol)e.nextElement()).parse();
	}

	public void print(PrintWriter ps)
	{
		Enumeration e = v.elements();
		if(e.hasMoreElements())
			((IdlSymbol)e.nextElement()).print(ps);
	
		for(; e.hasMoreElements();)
		{
			ps.print(",");
			((IdlSymbol)e.nextElement()).print(ps);
		}
	}
}







