/*
 * Decompiled with CFR 0.152.
 */
package jacorb.idl;

import jacorb.idl.Entry;
import jacorb.idl.Environment;
import jacorb.idl.IdlSymbol;
import jacorb.idl.parser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;

public class IRMap {
    public static final String mapFilename = "_irmap";
    private static Hashtable entries = new Hashtable();
    private static File file;

    public static void enter(IdlSymbol idlSymbol) {
        if (!parser.generateIRMap) {
            return;
        }
        Entry entry = idlSymbol.getEntry();
        Environment.output(2, "IR Map entry: " + entry.key());
        if (entries.containsKey(entry.key()) && entries.get(entry.key()).equals(entry)) {
            Environment.output(2, "replacing entry " + entry.key());
            entries.remove(entry.key());
        }
        entries.put(entry.key(), entry);
    }

    public static void update(File file) {
        Object object;
        IRMap.file = file;
        Hashtable hashtable = null;
        if (file.length() > 0L) {
            try {
                object = new ObjectInputStream(new FileInputStream(file));
                hashtable = (Hashtable)((ObjectInputStream)object).readObject();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(1);
            }
            object = entries.keys();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                Entry entry = (Entry)entries.get(string);
                if (hashtable.containsKey(string) && entries.get(string).equals(entry)) {
                    Environment.output(2, "replacing entry " + string);
                    hashtable.remove(string);
                }
                hashtable.put(string, entry);
            }
        } else {
            hashtable = entries;
        }
        try {
            object = new ObjectOutputStream(new FileOutputStream(IRMap.file));
            ((ObjectOutputStream)object).writeObject(hashtable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }
}

