/*
 * Decompiled with CFR 0.152.
 */
package jacorb.idl;

import jacorb.idl.ConstrTypeSpec;
import jacorb.idl.IRMap;
import jacorb.idl.IdlSymbol;
import jacorb.idl.NameAlreadyDefined;
import jacorb.idl.NameTable;
import jacorb.idl.ScopedName;
import jacorb.idl.SwitchTypeSpec;
import jacorb.idl.SymbolList;
import jacorb.idl.TypeDeclaration;
import jacorb.idl.TypeMap;
import jacorb.idl.TypeSpec;
import jacorb.idl.parser;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;

class EnumType
extends TypeDeclaration
implements SwitchTypeSpec {
    public SymbolList enumlist;
    int const_counter = 0;
    private boolean written = false;

    public EnumType(int n) {
        super(n);
        this.pack_name = "";
    }

    public boolean basic() {
        return true;
    }

    public String className() {
        String string;
        String string2 = this.typeName();
        if (string2.indexOf(46) > 0) {
            this.pack_name = string2.substring(0, string2.lastIndexOf(46));
            string = string2.substring(string2.lastIndexOf(46) + 1);
        } else {
            this.pack_name = "";
            string = string2;
        }
        return string;
    }

    public Object clone() {
        EnumType enumType = new EnumType(IdlSymbol.new_num());
        enumType.enumlist = this.enumlist;
        enumType.pack_name = this.pack_name;
        enumType.name = this.name;
        enumType.included = this.included;
        return enumType;
    }

    public TypeDeclaration declaration() {
        return this;
    }

    public String getTypeCodeExpression() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("org.omg.CORBA.ORB.init().create_enum_tc(\"" + this.id() + "\",\"" + this.className() + "\",");
        stringBuffer.append("new String[]{");
        Enumeration enumeration = this.enumlist.v.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append("\"" + (String)enumeration.nextElement() + "\"");
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("})");
        return stringBuffer.toString();
    }

    public String holderName() {
        return String.valueOf(this.typeName()) + "Holder";
    }

    public void parse() {
        this.escapeName();
        try {
            ConstrTypeSpec constrTypeSpec = new ConstrTypeSpec(IdlSymbol.new_num());
            constrTypeSpec.c_type_spec = this;
            NameTable.define(this.full_name(), "type");
            TypeMap.typedef(this.full_name(), constrTypeSpec);
            String string = null;
            String string2 = this.pack_name.length() > 0 ? String.valueOf(this.pack_name) + "." : "";
            Enumeration enumeration = this.enumlist.v.elements();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                try {
                    NameTable.define(String.valueOf(string2) + string, "enum label");
                    ScopedName.enumMap(String.valueOf(string2) + string, String.valueOf(this.full_name()) + "." + string);
                }
                catch (NameAlreadyDefined nameAlreadyDefined) {
                    parser.error("Identifier " + string + " already defined \n" + "(Enums don't define new scopes in IDL)", this.token);
                }
            }
        }
        catch (NameAlreadyDefined nameAlreadyDefined) {
            parser.error("Enum " + this.full_name() + " already defined", this.token);
        }
    }

    public void print(PrintWriter printWriter) {
        if (this.included && !this.generateIncluded()) {
            return;
        }
        if (this.written) {
            return;
        }
        try {
            String string = this.className();
            String string2 = String.valueOf(parser.out_dir) + IdlSymbol.fileSeparator + this.pack_name.replace('.', IdlSymbol.fileSeparator);
            File file = new File(string2);
            if (!file.exists() && !file.mkdirs()) {
                System.err.println("Unable to create " + string2);
                System.exit(1);
            }
            String string3 = String.valueOf(string) + ".java";
            PrintWriter printWriter2 = new PrintWriter(new FileWriter(new File(file, string3)));
            this.printEnumClass(string, printWriter2);
            printWriter2.close();
            string3 = String.valueOf(string) + "Holder.java";
            printWriter2 = new PrintWriter(new FileWriter(new File(file, string3)));
            this.printHolderClass(string, printWriter2);
            printWriter2.close();
            string3 = String.valueOf(string) + "Helper.java";
            printWriter2 = new PrintWriter(new FileWriter(new File(file, string3)));
            this.printHelperClass(string, printWriter2);
            printWriter2.close();
            IRMap.enter(this);
            this.written = true;
        }
        catch (IOException iOException) {
            System.err.println("File IO error");
            iOException.printStackTrace();
        }
    }

    private void printEnumClass(String string, PrintWriter printWriter) {
        Object object;
        if (!this.pack_name.equals("")) {
            printWriter.println("package " + this.pack_name + ";");
        }
        printWriter.println("public final class " + string);
        printWriter.println("\timplements org.omg.CORBA.portable.IDLEntity\n{");
        printWriter.println("\tprivate int value = -1;");
        Enumeration enumeration = this.enumlist.v.elements();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            printWriter.println("\tpublic static final int _" + (String)object + " = " + this.const_counter++ + ";");
            printWriter.println("\tpublic static final " + this.name + " " + (String)object + " = new " + this.name + "(_" + (String)object + ");");
        }
        printWriter.println("\tpublic int value()");
        printWriter.println("\t{");
        printWriter.println("\t\treturn value;");
        printWriter.println("\t}");
        printWriter.println("\tpublic static " + this.name + " from_int(int value)");
        printWriter.println("\t{");
        printWriter.println("\t\tswitch (value) {");
        object = this.enumlist.v.elements();
        while (object.hasMoreElements()) {
            String string2 = (String)object.nextElement();
            printWriter.println("\t\t\tcase _" + string2 + ": return " + string2 + ";");
        }
        printWriter.println("\t\t\tdefault: throw new org.omg.CORBA.BAD_PARAM();");
        printWriter.println("\t\t}");
        printWriter.println("\t}");
        printWriter.println("\tprotected " + this.name + "(int i)");
        printWriter.println("\t{");
        printWriter.println("\t\tvalue = i;");
        printWriter.println("\t}");
        printWriter.println("}");
    }

    private void printHelperClass(String string, PrintWriter printWriter) {
        if (!this.pack_name.equals("")) {
            printWriter.println("package " + this.pack_name + ";");
        }
        printWriter.println("public class " + string + "Helper");
        printWriter.println("{");
        printWriter.println("\tprivate static org.omg.CORBA.TypeCode _type = " + this.getTypeCodeExpression() + ";");
        printWriter.println("\tpublic " + string + "Helper ()");
        printWriter.println("\t{");
        printWriter.println("\t}");
        String string2 = this.typeName();
        TypeSpec.printHelperClassMethods(string, printWriter, string2);
        this.printIdMethod(printWriter);
        printWriter.println("\tpublic static " + string + " read(org.omg.CORBA.portable.InputStream in)");
        printWriter.println("\t{");
        printWriter.println("\t\treturn " + string + ".from_int( in.read_long());");
        printWriter.println("\t}");
        printWriter.println("\tpublic static void write(org.omg.CORBA.portable.OutputStream out, " + string + " s)");
        printWriter.println("\t{");
        printWriter.println("\t\tout.write_long(s.value());");
        printWriter.println("\t}");
        printWriter.println("}");
    }

    private void printHolderClass(String string, PrintWriter printWriter) {
        if (!this.pack_name.equals("")) {
            printWriter.println("package " + this.pack_name + ";");
        }
        printWriter.println("final public class " + string + "Holder");
        printWriter.println("\timplements org.omg.CORBA.portable.Streamable");
        printWriter.println("{");
        printWriter.println("\tpublic " + string + " value;\n");
        printWriter.println("\tpublic " + string + "Holder ()");
        printWriter.println("\t{");
        printWriter.println("\t}");
        printWriter.println("\tpublic " + string + "Holder (" + string + " initial)");
        printWriter.println("\t{");
        printWriter.println("\t\tvalue = initial;");
        printWriter.println("\t}");
        printWriter.println("\tpublic org.omg.CORBA.TypeCode _type()");
        printWriter.println("\t{");
        printWriter.println("\t\treturn " + string + "Helper.type();");
        printWriter.println("\t}");
        printWriter.println("\tpublic void _read(org.omg.CORBA.portable.InputStream in)");
        printWriter.println("\t{");
        printWriter.println("\t\tvalue = " + string + "Helper.read(in);");
        printWriter.println("\t}");
        printWriter.println("\tpublic void _write(org.omg.CORBA.portable.OutputStream out)");
        printWriter.println("\t{");
        printWriter.println("\t\t" + string + "Helper.write(out,value);");
        printWriter.println("\t}");
        printWriter.println("}");
    }

    public String printReadExpression(String string) {
        return String.valueOf(this.toString()) + "Helper.read(" + string + ")";
    }

    public String printWriteStatement(String string, String string2) {
        return String.valueOf(this.toString()) + "Helper.write(" + string2 + "," + string + ");";
    }

    public void setEnclosingSymbol(IdlSymbol idlSymbol) {
        if (this.enclosing_symbol != null && this.enclosing_symbol != idlSymbol) {
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        this.enclosing_symbol = idlSymbol;
    }

    public void setPackage(String string, boolean bl) {
        string = parser.pack_replace(string);
        this.pack_name = this.pack_name.length() > 0 ? new String(String.valueOf(string) + "." + this.pack_name) : string;
    }

    public void set_included(boolean bl) {
        this.included = bl;
    }

    public String signature() {
        return "L" + this.typeName() + ";";
    }

    public int size() {
        return this.enumlist.v.size();
    }

    public String toString() {
        return this.typeName();
    }

    public String typeName() {
        if (this.pack_name.length() > 0) {
            String string = ScopedName.unPseudoName(String.valueOf(this.pack_name) + "." + this.name);
            if (!string.startsWith("org.omg")) {
                return String.valueOf(this.omg_package_prefix) + string;
            }
            return string;
        }
        return ScopedName.unPseudoName(this.name);
    }
}

