/*
 * Decompiled with CFR 0.152.
 */
package jacorb.trading.db.simple.types;

import java.io.Serializable;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.PropStruct;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.PropertyMode;

public class TypeProperty
implements Serializable {
    private String m_name;
    private int m_kind;
    private boolean m_sequence;
    private int m_mode;
    static final long serialVersionUID = 3756829227846447959L;

    public TypeProperty() {
    }

    public TypeProperty(PropStruct propStruct) {
        this.m_name = propStruct.name;
        this.m_mode = propStruct.mode.value();
        TCKind tCKind = propStruct.value_type.kind();
        if (tCKind == TCKind.tk_sequence) {
            this.m_sequence = true;
            try {
                TypeCode typeCode = propStruct.value_type.content_type();
                tCKind = typeCode.kind();
                this.m_kind = tCKind.value();
            }
            catch (BadKind badKind) {
                throw new RuntimeException();
            }
        } else {
            this.m_sequence = false;
            this.m_kind = tCKind.value();
        }
    }

    public PropStruct describe() {
        PropStruct propStruct = new PropStruct();
        ORB oRB = ORB.init();
        propStruct.name = this.m_name;
        if (this.m_sequence) {
            TypeCode typeCode = oRB.get_primitive_tc(TCKind.from_int(this.m_kind));
            propStruct.value_type = oRB.create_sequence_tc(0, typeCode);
        } else {
            propStruct.value_type = oRB.get_primitive_tc(TCKind.from_int(this.m_kind));
        }
        propStruct.mode = PropertyMode.from_int(this.m_mode);
        return propStruct;
    }

    public boolean equals(Object object) {
        TypeProperty typeProperty = (TypeProperty)object;
        return this.m_name.equals(typeProperty.getName());
    }

    public String getName() {
        return this.m_name;
    }

    public int hashCode() {
        return this.m_name.hashCode();
    }
}

