/*
 * Decompiled with CFR 0.152.
 */
package jacorb.trading.constraint;

public class ValueType {
    private int m_id;
    private boolean m_sequence;
    private static String[] s_typeNames = new String[]{"BOOLEAN", "SHORT", "USHORT", "LONG", "ULONG", "FLOAT", "DOUBLE", "CHAR", "STRING", "OTHER"};
    private static String[] s_longTypeNames = new String[]{"boolean", "short", "unsigned short", "long", "unsigned long", "float", "double", "char", "string", "other"};
    public static final int BOOLEAN = 0;
    public static final int SHORT = 1;
    public static final int USHORT = 2;
    public static final int LONG = 3;
    public static final int ULONG = 4;
    public static final int FLOAT = 5;
    public static final int DOUBLE = 6;
    public static final int CHAR = 7;
    public static final int STRING = 8;
    public static final int OTHER = 9;
    public static final int NUMTYPES = 10;
    private static int[][] s_promoteTable;

    static {
        int[][] nArrayArray = new int[10][];
        int[] nArray = new int[10];
        nArray[1] = -1;
        nArray[2] = -1;
        nArray[3] = -1;
        nArray[4] = -1;
        nArray[5] = -1;
        nArray[6] = -1;
        nArray[7] = -1;
        nArray[8] = -1;
        nArray[9] = -1;
        nArrayArray[0] = nArray;
        nArrayArray[1] = new int[]{-1, 3, 3, 3, 4, 5, 6, -1, -1, -1};
        nArrayArray[2] = new int[]{-1, 3, 3, 3, 4, 5, 6, -1, -1, -1};
        nArrayArray[3] = new int[]{-1, 3, 3, 3, 4, 5, 6, -1, -1, -1};
        nArrayArray[4] = new int[]{-1, 4, 4, 4, 4, 5, 6, -1, -1, -1};
        nArrayArray[5] = new int[]{-1, 5, 5, 5, 5, 5, 6, -1, -1, -1};
        nArrayArray[6] = new int[]{-1, 6, 6, 6, 6, 6, 6, -1, -1, -1};
        nArrayArray[7] = new int[]{-1, -1, -1, -1, -1, -1, -1, 7, 8, -1};
        nArrayArray[8] = new int[]{-1, -1, -1, -1, -1, -1, -1, 8, 8, -1};
        nArrayArray[9] = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        s_promoteTable = nArrayArray;
    }

    public ValueType() {
        this(9, false);
    }

    public ValueType(int n) {
        this(n, false);
    }

    public ValueType(int n, boolean bl) {
        this.m_id = n;
        this.m_sequence = bl;
    }

    public ValueType(ValueType valueType) {
        this.m_id = valueType.m_id;
        this.m_sequence = valueType.m_sequence;
    }

    protected boolean checkNumeric(int n) {
        boolean bl = n != 8 && n != 9 && n != 0;
        return bl;
    }

    public boolean equals(ValueType valueType) {
        return this.m_id == valueType.m_id && this.m_sequence == valueType.m_sequence;
    }

    public int getId() {
        return this.m_id;
    }

    public String getLongTypeName() {
        return s_longTypeNames[this.m_id];
    }

    public static String getLongTypeName(int n) {
        return s_longTypeNames[n];
    }

    public String getTypeName() {
        return s_typeNames[this.m_id];
    }

    public static String getTypeName(int n) {
        return s_typeNames[n];
    }

    public static boolean isCompatible(int n, int n2) {
        return s_promoteTable[n][n2] != -1;
    }

    public boolean isNumber() {
        return this.checkNumeric(this.m_id);
    }

    public boolean isSequence() {
        return this.m_sequence;
    }

    public static int promote(int n, int n2) {
        int n3 = s_promoteTable[n][n2];
        return n3;
    }

    public String toString() {
        String string = this.m_sequence ? "sequence<" + this.getLongTypeName() + ">" : this.getLongTypeName();
        return string;
    }
}

