/*
 * Decompiled with CFR 0.152.
 */
package jacorb.orb.ir;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassPath {
    private PathEntry[] paths;

    public ClassPath() {
        this(ClassPath.getClassPath());
    }

    public ClassPath(String string) {
        Vector<PathEntry> vector = new Vector<PathEntry>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, System.getProperty("path.separator"));
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("")) continue;
            File file = new File(string2);
            try {
                if (!file.exists()) continue;
                if (file.isDirectory()) {
                    vector.addElement(new Dir(string2));
                    continue;
                }
                vector.addElement(new Zip(new ZipFile(file)));
            }
            catch (IOException iOException) {
                System.err.println("CLASSPATH component " + file + ": " + iOException);
            }
        }
        this.paths = new PathEntry[vector.size()];
        vector.copyInto(this.paths);
    }

    public byte[] getBytes(String string) throws IOException {
        return this.getBytes(string, ".class");
    }

    public byte[] getBytes(String string, String string2) throws IOException {
        InputStream inputStream = this.getInputStream(string);
        if (inputStream == null) {
            throw new IOException("Couldn't find: " + string + string2);
        }
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte[] byArray = new byte[inputStream.available()];
        dataInputStream.readFully(byArray);
        dataInputStream.close();
        inputStream.close();
        return byArray;
    }

    private static final String getClassPath() {
        String string;
        String string2 = System.getProperty("java.class.path");
        if (string2 == null) {
            string2 = "";
        }
        if ((string = System.getProperty("sun.boot.class.path")) == null) {
            string = "";
        }
        return String.valueOf(string2) + System.getProperty("path.separator") + string;
    }

    public InputStream getInputStream(String string) throws IOException {
        return this.getInputStream(string, ".class");
    }

    public InputStream getInputStream(String string, String string2) throws IOException {
        int n = 0;
        while (n < this.paths.length) {
            InputStream inputStream = this.paths[n].getInputStream(string, string2);
            if (inputStream != null) {
                return inputStream;
            }
            ++n;
        }
        throw new IOException("Couldn't find: " + string + string2);
    }

    public String getPath(String string) {
        int n = string.lastIndexOf(46);
        String string2 = "";
        if (n > 0) {
            string2 = string.substring(n);
            string = string.substring(0, n);
        }
        return this.getPath(string, string2);
    }

    public String getPath(String string, String string2) {
        string = string.replace('.', File.separatorChar);
        if (File.separatorChar != '/') {
            string = string.replace('/', File.separatorChar);
        }
        int n = 0;
        while (n < this.paths.length) {
            if (!(this.paths[n] instanceof Zip)) {
                File file = new File(String.valueOf(String.valueOf(this.paths[n])) + File.separatorChar + string + string2);
                try {
                    if (file.exists()) {
                        return file.getCanonicalPath();
                    }
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            ++n;
        }
        return null;
    }

    public PathEntry[] getPathEntries() {
        return this.paths;
    }

    public static abstract class PathEntry {
        abstract InputStream getInputStream(String var1, String var2) throws IOException;
    }

    public static class Dir
    extends PathEntry {
        private String dir;

        Dir(String string) {
            this.dir = string;
        }

        InputStream getInputStream(String string, String string2) throws IOException {
            File file = new File(String.valueOf(this.dir) + File.separatorChar + string.replace('.', File.separatorChar) + string2);
            return file.exists() ? new FileInputStream(file) : null;
        }

        public String toString() {
            return this.dir;
        }
    }

    public static class Zip
    extends PathEntry {
        private ZipFile zip;

        Zip(ZipFile zipFile) {
            this.zip = zipFile;
        }

        InputStream getInputStream(String string, String string2) throws IOException {
            ZipEntry zipEntry = this.zip.getEntry(String.valueOf(string.replace('.', '/')) + string2);
            if (zipEntry == null) {
                return null;
            }
            return this.zip.getInputStream(zipEntry);
        }
    }
}

