/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.Codecs;
import HTTPClient.ExtBufferedInputStream;
import HTTPClient.GlobalConstants;
import HTTPClient.HTTPConnection;
import HTTPClient.LinkedList;
import HTTPClient.ParseException;
import HTTPClient.Request;
import HTTPClient.RespInputStream;
import HTTPClient.Response;
import HTTPClient.ResponseHandler;
import HTTPClient.RetryException;
import HTTPClient.SocketTimeout;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;

class StreamDemultiplexor
implements GlobalConstants {
    private int Protocol;
    private HTTPConnection Connection;
    private ExtBufferedInputStream Stream;
    private Socket Sock = null;
    private ResponseHandler MarkedForClose;
    private SocketTimeout.TimeoutEntry Timer = null;
    private static SocketTimeout TimerThread = null;
    private LinkedList RespHandlerList;
    private int chunk_len;
    private int cur_timeout = 0;

    static {
        TimerThread = new SocketTimeout(60);
        TimerThread.start();
    }

    StreamDemultiplexor(int n, Socket socket, HTTPConnection hTTPConnection) throws IOException {
        this.Protocol = n;
        this.Connection = hTTPConnection;
        this.RespHandlerList = new LinkedList();
        this.init(socket);
    }

    void abort() {
        LinkedList linkedList = this.RespHandlerList;
        synchronized (linkedList) {
            ResponseHandler responseHandler = (ResponseHandler)this.RespHandlerList.enumerate();
            while (responseHandler != null) {
                if (responseHandler.resp.http_resp != null) {
                    responseHandler.resp.http_resp.markAborted();
                }
                if (responseHandler.exception == null) {
                    responseHandler.exception = new IOException("Request aborted by user");
                }
                responseHandler = (ResponseHandler)this.RespHandlerList.next();
            }
            if (this.Sock != null) {
                try {
                    try {
                        this.Sock.setSoLinger(false, 0);
                    }
                    catch (Throwable throwable) {}
                    try {
                        this.Stream.close();
                    }
                    catch (IOException iOException) {}
                    try {
                        this.Sock.close();
                    }
                    catch (IOException iOException) {}
                    this.Sock = null;
                    if (this.Timer != null) {
                        this.Timer.kill();
                        this.Timer = null;
                    }
                }
                catch (NullPointerException nullPointerException) {}
                this.Connection.DemuxList.remove(this);
            }
        }
    }

    synchronized int available(ResponseHandler responseHandler) throws IOException {
        int n = this.Stream.available();
        if (responseHandler == null) {
            return n;
        }
        if (responseHandler.exception != null) {
            throw (IOException)responseHandler.exception.fillInStackTrace();
        }
        if (responseHandler.eof) {
            return 0;
        }
        switch (responseHandler.resp.cd_type) {
            case 2: {
                return 0;
            }
            case 1: {
                return n > 0 ? 1 : 0;
            }
            case 3: {
                return n;
            }
            case 4: {
                int n2 = responseHandler.resp.ContentLength;
                return n < (n2 -= responseHandler.stream.count) ? n : n2;
            }
            case 5: {
                return n;
            }
            case 6: {
                return n;
            }
        }
        throw new Error("Internal Error in StreamDemultiplexor: Invalid cd_type " + responseHandler.resp.cd_type);
    }

    synchronized void close(ResponseHandler responseHandler) {
        if (responseHandler != (ResponseHandler)this.RespHandlerList.getFirst()) {
            return;
        }
        responseHandler.eof = true;
        this.RespHandlerList.remove(responseHandler);
        if (responseHandler == this.MarkedForClose) {
            this.close(new IOException("Premature end of Keep-Alive"), false);
        } else {
            this.closeSocketIfAllStreamsClosed();
        }
    }

    synchronized void close(IOException iOException, boolean bl) {
        if (this.Sock == null) {
            return;
        }
        try {
            this.Stream.close();
        }
        catch (IOException iOException2) {}
        try {
            this.Sock.close();
        }
        catch (IOException iOException3) {}
        this.Sock = null;
        if (this.Timer != null) {
            this.Timer.kill();
            this.Timer = null;
        }
        this.Connection.DemuxList.remove(this);
        if (iOException != null) {
            LinkedList linkedList = this.RespHandlerList;
            synchronized (linkedList) {
                this.retry_requests(iOException, bl);
            }
        }
    }

    synchronized void closeSocketIfAllStreamsClosed() {
        LinkedList linkedList = this.RespHandlerList;
        synchronized (linkedList) {
            ResponseHandler responseHandler = (ResponseHandler)this.RespHandlerList.enumerate();
            while (responseHandler != null && responseHandler.stream.closed) {
                if (responseHandler == this.MarkedForClose) {
                    ResponseHandler responseHandler2;
                    do {
                        responseHandler2 = (ResponseHandler)this.RespHandlerList.getFirst();
                        this.RespHandlerList.remove(responseHandler2);
                    } while (responseHandler2 != responseHandler);
                    this.close(new IOException("Premature end of Keep-Alive"), false);
                    Object var2_4 = null;
                    return;
                }
                responseHandler = (ResponseHandler)this.RespHandlerList.next();
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close(null, false);
        super.finalize();
    }

    synchronized Socket getSocket() {
        if (this.MarkedForClose != null) {
            return null;
        }
        if (this.Timer != null) {
            this.Timer.hyber();
        }
        return this.Sock;
    }

    RespInputStream getStream(Response response) {
        ResponseHandler responseHandler = (ResponseHandler)this.RespHandlerList.enumerate();
        while (responseHandler != null) {
            if (responseHandler.resp == response) break;
            responseHandler = (ResponseHandler)this.RespHandlerList.next();
        }
        if (responseHandler != null) {
            return responseHandler.stream;
        }
        return null;
    }

    private void init(Socket socket) throws IOException {
        this.Sock = socket;
        this.Stream = new ExtBufferedInputStream(socket.getInputStream());
        this.MarkedForClose = null;
        this.chunk_len = -1;
        this.Timer = TimerThread.setTimeout(this);
    }

    synchronized void markForClose(Response response) {
        Object object = this.RespHandlerList;
        synchronized (object) {
            if (this.RespHandlerList.getFirst() == null) {
                this.close(new IOException("Premature end of Keep-Alive"), false);
                Object var3_3 = null;
                return;
            }
        }
        if (this.Timer != null) {
            this.Timer.kill();
            this.Timer = null;
        }
        Object object2 = null;
        object = (ResponseHandler)this.RespHandlerList.enumerate();
        while (object != null) {
            if (((ResponseHandler)object).resp == response) {
                this.MarkedForClose = object;
                this.closeSocketIfAllStreamsClosed();
                return;
            }
            if (this.MarkedForClose == object) {
                return;
            }
            object2 = object;
            object = (ResponseHandler)this.RespHandlerList.next();
        }
        if (object2 == null) {
            return;
        }
        this.MarkedForClose = object2;
        this.closeSocketIfAllStreamsClosed();
    }

    /*
     * Unable to fully structure code
     */
    int read(byte[] var1_1, int var2_2, int var3_3, ResponseHandler var4_4, int var5_5) throws IOException {
        if (var4_4.exception != null) {
            throw (IOException)var4_4.exception.fillInStackTrace();
        }
        if (!var4_4.eof) ** GOTO lbl12
        return -1;
lbl-1000:
        // 1 sources

        {
            try {
                var6_6.stream.readAll(var5_5);
                continue;
            }
            catch (IOException var7_7) {
                if (var7_7 instanceof InterruptedIOException) {
                    throw var7_7;
                }
                throw (IOException)var4_4.exception.fillInStackTrace();
            }
lbl12:
            // 2 sources

            ** while ((var6_6 = (ResponseHandler)this.RespHandlerList.getFirst()) != null && var6_6 != var4_4)
        }
lbl13:
        // 1 sources

        var8_9 = this;
        synchronized (var8_9) {
            if (var4_4.exception != null) {
                throw (IOException)var4_4.exception.fillInStackTrace();
            }
            if (this.Timer != null) {
                this.Timer.hyber();
            }
            try {
                var10_10 = -1;
                if (var5_5 != this.cur_timeout) {
                    try {
                        this.Sock.setSoTimeout(var5_5);
                    }
                    catch (Throwable v0) {}
                    this.cur_timeout = var5_5;
                }
                switch (var4_4.resp.cd_type) {
                    case 1: {
                        var10_10 = this.Stream.read(var1_1, var2_2, var3_3);
                        if (var10_10 != -1) break;
                        throw new EOFException("Premature EOF encountered");
                    }
                    case 2: {
                        var10_10 = -1;
                        this.close(var4_4);
                        break;
                    }
                    case 3: {
                        var10_10 = this.Stream.read(var1_1, var2_2, var3_3);
                        if (var10_10 != -1) break;
                        this.close(var4_4);
                        break;
                    }
                    case 4: {
                        var11_14 = var4_4.resp.ContentLength;
                        if (var3_3 > var11_14 - var4_4.stream.count) {
                            var3_3 = var11_14 - var4_4.stream.count;
                        }
                        if ((var10_10 = this.Stream.read(var1_1, var2_2, var3_3)) == -1) {
                            throw new EOFException("Premature EOF encountered");
                        }
                        if (var4_4.stream.count + var10_10 != var11_14) break;
                        this.close(var4_4);
                        break;
                    }
                    case 5: {
                        if (this.chunk_len == -1) {
                            this.chunk_len = Codecs.getChunkLength(this.Stream);
                        }
                        if (this.chunk_len > 0) {
                            if (var3_3 > this.chunk_len) {
                                var3_3 = this.chunk_len;
                            }
                            if ((var10_10 = this.Stream.read(var1_1, var2_2, var3_3)) == -1) {
                                throw new EOFException("Premature EOF encountered");
                            }
                            this.chunk_len -= var10_10;
                            if (this.chunk_len != 0) break;
                            this.Stream.read();
                            this.Stream.read();
                            this.chunk_len = -1;
                            break;
                        }
                        var4_4.resp.readTrailers(this.Stream);
                        var10_10 = -1;
                        this.close(var4_4);
                        this.chunk_len = -1;
                        break;
                    }
                    case 6: {
                        var12_15 = var4_4.getEndBoundary(this.Stream);
                        var13_16 = var4_4.getEndCompiled(this.Stream);
                        var10_10 = this.Stream.read(var1_1, var2_2, var3_3);
                        if (var10_10 == -1) {
                            throw new EOFException("Premature EOF encountered");
                        }
                        var14_17 = this.Stream.pastEnd(var12_15, var13_16);
                        if (var14_17 == -1) break;
                        var10_10 -= var14_17;
                        this.Stream.reset();
                        this.close(var4_4);
                        break;
                    }
                    default: {
                        throw new Error("Internal Error in StreamDemultiplexor: Invalid cd_type " + var4_4.resp.cd_type);
                    }
                }
                this.restartTimer();
                var7_8 = var10_10;
                var9_18 = null;
                return var7_8;
            }
            catch (InterruptedIOException var10_11) {
                this.restartTimer();
                throw var10_11;
            }
            catch (IOException var10_12) {
                this.close(var10_12, true);
                throw var4_4.exception;
            }
            catch (ParseException var10_13) {
                this.close(new IOException(var10_13.toString()), true);
                throw var4_4.exception;
            }
        }
    }

    void register(Response response, Request request) throws RetryException {
        LinkedList linkedList = this.RespHandlerList;
        synchronized (linkedList) {
            if (this.Sock == null) {
                throw new RetryException();
            }
            this.RespHandlerList.addToEnd(new ResponseHandler(response, request, this));
        }
    }

    void restartTimer() {
        if (this.Timer != null) {
            this.Timer.reset();
        }
    }

    private void retry_requests(IOException iOException, boolean bl) {
        RetryException retryException = null;
        RetryException retryException2 = null;
        ResponseHandler responseHandler = (ResponseHandler)this.RespHandlerList.enumerate();
        while (responseHandler != null) {
            if (responseHandler.resp.got_headers) {
                responseHandler.exception = iOException;
            } else {
                RetryException retryException3 = new RetryException(iOException.getMessage());
                if (retryException == null) {
                    retryException = retryException3;
                }
                retryException3.request = responseHandler.request;
                retryException3.response = responseHandler.resp;
                retryException3.exception = iOException;
                retryException3.conn_reset = bl;
                retryException3.first = retryException;
                retryException3.addToListAfter(retryException2);
                retryException2 = retryException3;
                responseHandler.exception = retryException3;
            }
            this.RespHandlerList.remove(responseHandler);
            responseHandler = (ResponseHandler)this.RespHandlerList.next();
        }
    }

    synchronized long skip(long l, ResponseHandler responseHandler) throws IOException {
        if (responseHandler.exception != null) {
            throw (IOException)responseHandler.exception.fillInStackTrace();
        }
        if (responseHandler.eof) {
            return 0L;
        }
        byte[] byArray = new byte[(int)l];
        int n = this.read(byArray, 0, (int)l, responseHandler, 0);
        if (n == -1) {
            return 0L;
        }
        return n;
    }

    public String toString() {
        String string;
        switch (this.Protocol) {
            case 0: {
                string = "HTTP";
                break;
            }
            case 1: {
                string = "HTTPS";
                break;
            }
            case 2: {
                string = "SHTTP";
                break;
            }
            case 3: {
                string = "HTTP_NG";
                break;
            }
            default: {
                throw new Error("HTTPClient Internal Error: invalid protocol " + this.Protocol);
            }
        }
        return String.valueOf(this.getClass().getName()) + "[Protocol=" + string + "]";
    }
}

