/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.CIHashtable;
import HTTPClient.GlobalConstants;
import HTTPClient.HTTPClientModule;
import HTTPClient.HTTPClientModuleConstants;
import HTTPClient.HttpOutputStream;
import HTTPClient.ModuleException;
import HTTPClient.ParseException;
import HTTPClient.Request;
import HTTPClient.Response;
import HTTPClient.URI;
import HTTPClient.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;

public class HTTPResponse
implements GlobalConstants,
HTTPClientModuleConstants {
    private HTTPClientModule[] modules;
    private int timeout;
    private Request request = null;
    private Response response = null;
    private HttpOutputStream out_stream = null;
    private InputStream inp_stream;
    private int StatusCode;
    private String ReasonLine;
    private String Version;
    private URI OriginalURI = null;
    private URI EffectiveURI = null;
    private CIHashtable Headers = null;
    private CIHashtable Trailers = null;
    private int ContentLength = -1;
    private byte[] Data = null;
    private boolean initialized = false;
    private boolean got_trailers = false;
    private boolean aborted = false;
    private String method = null;
    private boolean handle_trailers = false;
    private boolean trailers_handled = false;

    HTTPResponse(HTTPClientModule[] hTTPClientModuleArray, int n, Request request) {
        this.modules = hTTPClientModuleArray;
        this.timeout = n;
        try {
            this.OriginalURI = new URI(request.getConnection().getProtocol(), request.getConnection().getHost(), request.getConnection().getPort(), request.getRequestURI());
        }
        catch (ParseException parseException) {}
        this.method = request.getMethod();
    }

    public synchronized byte[] getData() throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        if (this.Data == null) {
            try {
                this.readResponseData(this.inp_stream);
            }
            catch (InterruptedIOException interruptedIOException) {
                throw interruptedIOException;
            }
            catch (IOException iOException) {
                try {
                    this.inp_stream.close();
                }
                catch (Exception exception) {}
                throw iOException;
            }
            this.inp_stream.close();
        }
        return this.Data;
    }

    public final URI getEffectiveURI() throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        if (this.EffectiveURI != null) {
            return this.EffectiveURI;
        }
        return this.OriginalURI;
    }

    public final URL getEffectiveURL() throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        if (this.EffectiveURI != null) {
            return this.EffectiveURI.toURL();
        }
        return null;
    }

    public String getHeader(String string) throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        return (String)this.Headers.get(string.trim());
    }

    public Date getHeaderAsDate(String string) throws IOException, IllegalArgumentException, ModuleException {
        Date date;
        String string2 = this.getHeader(string);
        if (string2 == null) {
            return null;
        }
        if (string2.toUpperCase().indexOf("GMT") == -1) {
            string2 = String.valueOf(string2) + " GMT";
        }
        try {
            date = new Date(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            long l;
            try {
                l = Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw illegalArgumentException;
            }
            if (l < 0L) {
                l = 0L;
            }
            date = new Date(l * 1000L);
        }
        return date;
    }

    public int getHeaderAsInt(String string) throws IOException, ModuleException, NumberFormatException {
        return Integer.parseInt(this.getHeader(string));
    }

    public synchronized InputStream getInputStream() throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        if (this.Data == null) {
            return this.inp_stream;
        }
        this.getData();
        return new ByteArrayInputStream(this.Data);
    }

    HTTPClientModule[] getModules() {
        return this.modules;
    }

    public final URI getOriginalURI() {
        return this.OriginalURI;
    }

    public final String getReasonLine() throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        return this.ReasonLine;
    }

    public final String getServer() throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        return this.getHeader("Server");
    }

    public final int getStatusCode() throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        return this.StatusCode;
    }

    int getTimeout() {
        return this.timeout;
    }

    public String getTrailer(String string) throws IOException, ModuleException {
        if (!this.got_trailers) {
            this.getTrailers();
        }
        return (String)this.Trailers.get(string.trim());
    }

    public Date getTrailerAsDate(String string) throws IOException, IllegalArgumentException, ModuleException {
        Date date;
        String string2 = this.getTrailer(string);
        if (string2 == null) {
            return null;
        }
        if (string2.toUpperCase().indexOf("GMT") == -1) {
            string2 = String.valueOf(string2) + " GMT";
        }
        try {
            date = new Date(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            long l;
            try {
                l = Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw illegalArgumentException;
            }
            if (l < 0L) {
                l = 0L;
            }
            date = new Date(l * 1000L);
        }
        return date;
    }

    public int getTrailerAsInt(String string) throws IOException, ModuleException, NumberFormatException {
        return Integer.parseInt(this.getTrailer(string));
    }

    private synchronized void getTrailers() throws IOException, ModuleException {
        if (this.got_trailers) {
            return;
        }
        if (!this.initialized) {
            this.handleResponse();
        }
        this.response.getTrailer("Any");
        this.Trailers = this.response.Trailers;
        this.got_trailers = true;
        this.invokeTrailerHandlers(false);
    }

    public final String getVersion() throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        return this.Version;
    }

    /*
     * Exception decompiling
     */
    synchronized boolean handleResponse() throws IOException, ModuleException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void init(Response response) {
        if (this.initialized) {
            return;
        }
        this.StatusCode = response.StatusCode;
        this.ReasonLine = response.ReasonLine;
        this.Version = response.Version;
        this.EffectiveURI = response.EffectiveURI;
        this.ContentLength = response.ContentLength;
        this.Headers = response.Headers;
        this.inp_stream = response.inp_stream;
        this.Data = response.Data;
        this.initialized = true;
    }

    void invokeTrailerHandlers(boolean bl) throws IOException, ModuleException {
        if (this.trailers_handled) {
            return;
        }
        if (!bl && !this.initialized) {
            this.handle_trailers = true;
            return;
        }
        int n = 0;
        while (n < this.modules.length && !this.aborted) {
            this.modules[n].trailerHandler(this.response, this.request);
            ++n;
        }
        this.trailers_handled = true;
    }

    public Enumeration listHeaders() throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        return this.Headers.keys();
    }

    public Enumeration listTrailers() throws IOException, ModuleException {
        if (!this.got_trailers) {
            this.getTrailers();
        }
        return this.Trailers.keys();
    }

    void markAborted() {
        this.aborted = true;
    }

    private void readResponseData(InputStream inputStream) throws IOException, ModuleException {
        if (this.ContentLength == 0) {
            return;
        }
        if (this.Data == null) {
            this.Data = new byte[0];
        }
        int n = this.Data.length;
        try {
            try {
                if (this.getHeader("Content-Length") != null) {
                    int n2 = 0;
                    this.Data = new byte[this.ContentLength];
                    while ((n2 = inputStream.read(this.Data, n += n2, this.ContentLength - n)) != -1 && n + n2 < this.ContentLength) {
                    }
                } else {
                    int n3 = 1000;
                    int n4 = 0;
                    do {
                        this.Data = Util.resizeArray(this.Data, (n += n4) + n3);
                    } while ((n4 = inputStream.read(this.Data, n, n3)) != -1);
                    this.Data = Util.resizeArray(this.Data, n);
                }
            }
            catch (IOException iOException) {
                this.Data = Util.resizeArray(this.Data, n);
                throw iOException;
            }
            Object var4_7 = null;
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
    }

    void set(Request request, HttpOutputStream httpOutputStream) {
        this.request = request;
        this.out_stream = httpOutputStream;
    }

    void set(Request request, Response response) {
        this.request = request;
        this.response = response;
        response.http_resp = this;
        response.timeout = this.timeout;
        this.aborted = response.final_resp;
    }

    public String toString() {
        if (!this.initialized) {
            try {
                this.handleResponse();
            }
            catch (Exception exception) {
                return "Failed to read headers: " + exception;
            }
        }
        String string = System.getProperty("line.separator", "\n");
        StringBuffer stringBuffer = new StringBuffer(this.Version);
        stringBuffer.append(' ');
        stringBuffer.append(this.StatusCode);
        stringBuffer.append(' ');
        stringBuffer.append(this.ReasonLine);
        stringBuffer.append(string);
        if (this.EffectiveURI != null) {
            stringBuffer.append("Effective-URI: ");
            stringBuffer.append(this.EffectiveURI);
            stringBuffer.append(string);
        }
        Enumeration enumeration = this.Headers.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            stringBuffer.append(string2);
            stringBuffer.append(": ");
            stringBuffer.append(this.Headers.get(string2));
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

