/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.AuthSchemeNotImplException;
import HTTPClient.AuthorizationHandler;
import HTTPClient.Codecs;
import HTTPClient.DefaultAuthHandler;
import HTTPClient.GlobalConstants;
import HTTPClient.HTTPConnection;
import HTTPClient.MD5;
import HTTPClient.NVPair;
import HTTPClient.RoRequest;
import HTTPClient.RoResponse;
import HTTPClient.Util;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class AuthorizationInfo
implements GlobalConstants,
Cloneable {
    private static Hashtable CntxtList = new Hashtable();
    private static AuthorizationHandler AuthHandler = new DefaultAuthHandler();
    private String host;
    private int port;
    private String scheme;
    private String realm;
    private String cookie;
    private NVPair[] auth_params = new NVPair[0];
    private Object extra_info = null;
    private String[] paths = new String[0];

    static {
        CntxtList.put(HTTPConnection.getDefaultContext(), new Hashtable());
    }

    AuthorizationInfo(AuthorizationInfo authorizationInfo) {
        this.scheme = authorizationInfo.scheme;
        this.host = authorizationInfo.host;
        this.port = authorizationInfo.port;
        this.realm = authorizationInfo.realm;
        this.cookie = authorizationInfo.cookie;
        this.auth_params = Util.resizeArray(authorizationInfo.auth_params, authorizationInfo.auth_params.length);
        this.extra_info = authorizationInfo.extra_info;
    }

    AuthorizationInfo(String string, int n) {
        this.host = string.trim().toLowerCase();
        this.port = n;
    }

    public AuthorizationInfo(String string, int n, String string2, String string3, String string4) {
        this.scheme = string2.trim();
        this.host = string.trim().toLowerCase();
        this.port = n;
        this.realm = string3;
        this.cookie = string4 != null ? string4.trim() : null;
    }

    public AuthorizationInfo(String string, int n, String string2, String string3, NVPair[] nVPairArray, Object object) {
        this.scheme = string2.trim();
        this.host = string.trim().toLowerCase();
        this.port = n;
        this.realm = string3;
        this.cookie = null;
        if (nVPairArray != null) {
            this.auth_params = Util.resizeArray(nVPairArray, nVPairArray.length);
        }
        this.extra_info = object;
    }

    public static void addAuthorization(AuthorizationInfo authorizationInfo) {
        AuthorizationInfo.addAuthorization(authorizationInfo, HTTPConnection.getDefaultContext());
    }

    public static void addAuthorization(AuthorizationInfo authorizationInfo, Object object) {
        Hashtable hashtable = Util.getList(CntxtList, object);
        AuthorizationInfo authorizationInfo2 = (AuthorizationInfo)hashtable.get(authorizationInfo);
        if (authorizationInfo2 != null) {
            int n = authorizationInfo2.paths.length;
            int n2 = authorizationInfo.paths.length;
            if (n2 == 0) {
                authorizationInfo.paths = authorizationInfo2.paths;
            } else {
                authorizationInfo.paths = Util.resizeArray(authorizationInfo.paths, n2 + n);
                System.arraycopy(authorizationInfo2.paths, 0, authorizationInfo.paths, n2, n);
            }
        }
        hashtable.put(authorizationInfo, authorizationInfo);
    }

    public static void addAuthorization(String string, int n, String string2, String string3, String string4, NVPair[] nVPairArray, Object object) {
        AuthorizationInfo.addAuthorization(string, n, string2, string3, string4, nVPairArray, object, HTTPConnection.getDefaultContext());
    }

    public static void addAuthorization(String string, int n, String string2, String string3, String string4, NVPair[] nVPairArray, Object object, Object object2) {
        AuthorizationInfo authorizationInfo = new AuthorizationInfo(string, n, string2, string3, string4);
        if (nVPairArray != null && nVPairArray.length > 0) {
            authorizationInfo.auth_params = Util.resizeArray(nVPairArray, nVPairArray.length);
        }
        authorizationInfo.extra_info = object;
        AuthorizationInfo.addAuthorization(authorizationInfo, object2);
    }

    public static void addBasicAuthorization(String string, int n, String string2, String string3, String string4) {
        AuthorizationInfo.addAuthorization(string, n, "Basic", string2, Codecs.base64Encode(String.valueOf(string3) + ":" + string4), null, null);
    }

    public static void addBasicAuthorization(String string, int n, String string2, String string3, String string4, Object object) {
        AuthorizationInfo.addAuthorization(string, n, "Basic", string2, Codecs.base64Encode(String.valueOf(string3) + ":" + string4), null, null, object);
    }

    public static void addDigestAuthorization(String string, int n, String string2, String string3, String string4) {
        AuthorizationInfo.addDigestAuthorization(string, n, string2, string3, string4, HTTPConnection.getDefaultContext());
    }

    public static void addDigestAuthorization(String string, int n, String string2, String string3, String string4, Object object) {
        NVPair[] nVPairArray;
        AuthorizationInfo authorizationInfo = AuthorizationInfo.getAuthorization(string, n, "Digest", string2, object);
        if (authorizationInfo == null) {
            nVPairArray = new NVPair[]{new NVPair("username", string3), new NVPair("uri", ""), new NVPair("nonce", ""), new NVPair("response", "")};
        } else {
            nVPairArray = authorizationInfo.getParams();
            int n2 = 0;
            while (n2 < nVPairArray.length) {
                if (nVPairArray[n2].getName().equalsIgnoreCase("username")) {
                    nVPairArray[n2] = new NVPair("username", string3);
                    break;
                }
                ++n2;
            }
        }
        String[] stringArray = new String[]{new MD5(String.valueOf(string3) + ":" + string2 + ":" + string4).asHex(), null};
        AuthorizationInfo.addAuthorization(string, n, "Digest", string2, null, nVPairArray, stringArray, object);
    }

    public synchronized void addPath(String string) {
        String string2 = Util.getPath(string);
        int n = 0;
        while (n < this.paths.length) {
            if (this.paths[n].equals(string2)) {
                return;
            }
            ++n;
        }
        this.paths = Util.resizeArray(this.paths, this.paths.length + 1);
        this.paths[this.paths.length - 1] = string2;
    }

    public Object clone() {
        AuthorizationInfo authorizationInfo;
        try {
            authorizationInfo = (AuthorizationInfo)super.clone();
            authorizationInfo.auth_params = Util.resizeArray(this.auth_params, this.auth_params.length);
            try {
                authorizationInfo.extra_info = this.extra_info.getClass().getMethod("clone", null).invoke(this.extra_info, null);
            }
            catch (Throwable throwable) {}
            authorizationInfo.paths = new String[this.paths.length];
            System.arraycopy(this.paths, 0, authorizationInfo.paths, 0, this.paths.length);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
        return authorizationInfo;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof AuthorizationInfo) {
            AuthorizationInfo authorizationInfo = (AuthorizationInfo)object;
            if (this.host.equals(authorizationInfo.host) && this.port == authorizationInfo.port && this.scheme.equalsIgnoreCase(authorizationInfo.scheme) && this.realm.equals(authorizationInfo.realm)) {
                return true;
            }
        }
        return false;
    }

    static AuthorizationInfo findBest(RoRequest roRequest) {
        int n;
        String[] stringArray;
        AuthorizationInfo authorizationInfo;
        String string = Util.getPath(roRequest.getRequestURI());
        String string2 = roRequest.getConnection().getHost();
        int n2 = roRequest.getConnection().getPort();
        Hashtable hashtable = Util.getList(CntxtList, roRequest.getConnection().getContext());
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            authorizationInfo = (AuthorizationInfo)enumeration.nextElement();
            if (!authorizationInfo.host.equals(string2) || authorizationInfo.port != n2) continue;
            stringArray = authorizationInfo.paths;
            n = 0;
            while (n < stringArray.length) {
                if (string.equals(stringArray[n])) {
                    return authorizationInfo;
                }
                ++n;
            }
        }
        authorizationInfo = null;
        stringArray = string.substring(0, string.lastIndexOf(47) + 1);
        n = Integer.MAX_VALUE;
        enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            AuthorizationInfo authorizationInfo2 = (AuthorizationInfo)enumeration.nextElement();
            if (!authorizationInfo2.host.equals(string2) || authorizationInfo2.port != n2) continue;
            String[] stringArray2 = authorizationInfo2.paths;
            int n3 = 0;
            while (n3 < stringArray2.length) {
                int n4;
                int n5;
                String string3 = stringArray2[n3].substring(0, stringArray2[n3].lastIndexOf(47) + 1);
                if (stringArray.equals(string3)) {
                    return authorizationInfo2;
                }
                if (stringArray.startsWith(string3)) {
                    n5 = 0;
                    n4 = string3.length() - 1;
                    while ((n4 = stringArray.indexOf(47, n4 + 1)) != -1) {
                        ++n5;
                    }
                    if (n5 < n) {
                        n = n5;
                        authorizationInfo = authorizationInfo2;
                    }
                } else if (string3.startsWith((String)stringArray)) {
                    n5 = 0;
                    n4 = stringArray.length();
                    while ((n4 = string3.indexOf(47, n4 + 1)) != -1) {
                        ++n5;
                    }
                    if (n5 < n) {
                        n = n5;
                        authorizationInfo = authorizationInfo2;
                    }
                }
                ++n3;
            }
        }
        return authorizationInfo;
    }

    public static AuthorizationHandler getAuthHandler() {
        return AuthHandler;
    }

    static synchronized AuthorizationInfo getAuthorization(AuthorizationInfo authorizationInfo, RoRequest roRequest, RoResponse roResponse, boolean bl) throws AuthSchemeNotImplException {
        Hashtable hashtable = roRequest != null ? Util.getList(CntxtList, roRequest.getConnection().getContext()) : Util.getList(CntxtList, HTTPConnection.getDefaultContext());
        AuthorizationInfo authorizationInfo2 = (AuthorizationInfo)hashtable.get(authorizationInfo);
        if (authorizationInfo2 == null && bl) {
            authorizationInfo2 = AuthorizationInfo.queryAuthHandler(authorizationInfo, roRequest, roResponse);
        }
        return authorizationInfo2;
    }

    public static AuthorizationInfo getAuthorization(String string, int n, String string2, String string3) {
        return AuthorizationInfo.getAuthorization(string, n, string2, string3, HTTPConnection.getDefaultContext());
    }

    public static synchronized AuthorizationInfo getAuthorization(String string, int n, String string2, String string3, Object object) {
        Hashtable hashtable = Util.getList(CntxtList, object);
        AuthorizationInfo authorizationInfo = new AuthorizationInfo(string.trim(), n, string2.trim(), string3, null, null);
        return (AuthorizationInfo)hashtable.get(authorizationInfo);
    }

    static AuthorizationInfo getAuthorization(String string, int n, String string2, String string3, boolean bl) throws AuthSchemeNotImplException {
        return AuthorizationInfo.getAuthorization(new AuthorizationInfo(string.trim(), n, string2.trim(), string3, null, null), null, null, bl);
    }

    public final String getCookie() {
        return this.cookie;
    }

    public final Object getExtraInfo() {
        return this.extra_info;
    }

    public final String getHost() {
        return this.host;
    }

    public final NVPair[] getParams() {
        return Util.resizeArray(this.auth_params, this.auth_params.length);
    }

    public final int getPort() {
        return this.port;
    }

    public final String getRealm() {
        return this.realm;
    }

    public final String getScheme() {
        return this.scheme;
    }

    public int hashCode() {
        return (String.valueOf(this.host) + this.scheme.toLowerCase() + this.realm).hashCode();
    }

    static AuthorizationInfo[] parseAuthString(String string, RoRequest roRequest, RoResponse roResponse) throws ProtocolException {
        int n = 0;
        int n2 = 0;
        char[] cArray = string.toCharArray();
        int n3 = cArray.length;
        AuthorizationInfo[] authorizationInfoArray = new AuthorizationInfo[]{};
        while (Character.isSpace(cArray[n3 - 1])) {
            --n3;
        }
        while ((n = Util.skipSpace(cArray, n)) != n3) {
            int n4;
            n2 = Util.findSpace(cArray, n + 1);
            try {
                n4 = roResponse.getStatusCode();
            }
            catch (IOException iOException) {
                throw new ProtocolException(iOException.toString());
            }
            AuthorizationInfo authorizationInfo = n4 == 401 ? new AuthorizationInfo(roRequest.getConnection().getHost(), roRequest.getConnection().getPort()) : new AuthorizationInfo(roRequest.getConnection().getProxyHost(), roRequest.getConnection().getProxyPort());
            authorizationInfo.scheme = string.substring(n, n2);
            boolean bl = true;
            Vector<NVPair> vector = new Vector<NVPair>();
            while ((n = Util.skipSpace(cArray, n2)) != n3) {
                String string2;
                if (!bl) {
                    if (cArray[n] != ',') {
                        throw new ProtocolException("Bad Authentication header format: '" + string + "'\nExpected \",\" at position " + n);
                    }
                    if ((n = Util.skipSpace(cArray, n + 1)) == n3) break;
                    if (cArray[n] == ',') {
                        n2 = n;
                        continue;
                    }
                }
                int n5 = n;
                n2 = n + 1;
                while (n2 < n3 && !Character.isSpace(cArray[n2]) && cArray[n2] != '=' && cArray[n2] != ',') {
                    ++n2;
                }
                if (bl && (n2 == n3 || cArray[n2] == '=' && (n2 + 1 == n3 || cArray[n2 + 1] == '=' && n2 + 2 == n3))) {
                    authorizationInfo.cookie = string.substring(n, n3);
                    n = n3;
                    break;
                }
                String string3 = string.substring(n, n2);
                n = Util.skipSpace(cArray, n2);
                if (n < n3 && cArray[n] != '=' && cArray[n] != ',') {
                    n = n5;
                    break;
                }
                if (cArray[n] == '=') {
                    if ((n = Util.skipSpace(cArray, n + 1)) == n3) {
                        throw new ProtocolException("Bad Authentication header format: " + string + "\nUnexpected EOL after token" + " at position " + (n2 - 1));
                    }
                    if (cArray[n] != '\"') {
                        n2 = Util.skipToken(cArray, n);
                        if (n2 == n) {
                            throw new ProtocolException("Bad Authentication header format: " + string + "\nToken expected at " + "position " + n);
                        }
                        string2 = string.substring(n, n2);
                    } else {
                        n2 = n++;
                        while ((n2 = string.indexOf(34, n2 + 1)) != -1 && string.charAt(n2 - 1) == '\\') {
                        }
                        if (n2 == -1) {
                            throw new ProtocolException("Bad Authentication header format: " + string + "\nClosing <\"> for " + "quoted-string starting at position " + n + " not found");
                        }
                        string2 = Util.dequoteString(string.substring(n, n2));
                        ++n2;
                    }
                } else {
                    string2 = null;
                }
                if (string3.equalsIgnoreCase("realm")) {
                    authorizationInfo.realm = string2;
                } else {
                    vector.addElement(new NVPair(string3, string2));
                }
                bl = false;
            }
            if (!vector.isEmpty()) {
                authorizationInfo.auth_params = new NVPair[vector.size()];
                vector.copyInto(authorizationInfo.auth_params);
            }
            if (authorizationInfo.realm == null) {
                authorizationInfo.realm = "";
            }
            authorizationInfoArray = Util.resizeArray(authorizationInfoArray, authorizationInfoArray.length + 1);
            authorizationInfoArray[authorizationInfoArray.length - 1] = authorizationInfo;
        }
        return authorizationInfoArray;
    }

    static AuthorizationInfo queryAuthHandler(AuthorizationInfo authorizationInfo, RoRequest roRequest, RoResponse roResponse) throws AuthSchemeNotImplException {
        if (AuthHandler == null) {
            return null;
        }
        AuthorizationInfo authorizationInfo2 = AuthHandler.getAuthorization(authorizationInfo, roRequest, roResponse);
        if (authorizationInfo2 != null) {
            if (roRequest != null) {
                AuthorizationInfo.addAuthorization((AuthorizationInfo)authorizationInfo2.clone(), roRequest.getConnection().getContext());
            } else {
                AuthorizationInfo.addAuthorization((AuthorizationInfo)authorizationInfo2.clone(), HTTPConnection.getDefaultContext());
            }
        }
        return authorizationInfo2;
    }

    public static void removeAuthorization(AuthorizationInfo authorizationInfo) {
        AuthorizationInfo.removeAuthorization(authorizationInfo, HTTPConnection.getDefaultContext());
    }

    public static void removeAuthorization(AuthorizationInfo authorizationInfo, Object object) {
        Hashtable hashtable = Util.getList(CntxtList, object);
        hashtable.remove(authorizationInfo);
    }

    public static void removeAuthorization(String string, int n, String string2, String string3) {
        AuthorizationInfo.removeAuthorization(new AuthorizationInfo(string, n, string2, string3, null, null));
    }

    public static void removeAuthorization(String string, int n, String string2, String string3, Object object) {
        AuthorizationInfo.removeAuthorization(new AuthorizationInfo(string, n, string2, string3, null, null), object);
    }

    public static AuthorizationHandler setAuthHandler(AuthorizationHandler authorizationHandler) {
        AuthorizationHandler authorizationHandler2 = AuthHandler;
        AuthHandler = authorizationHandler;
        return authorizationHandler2;
    }

    public final void setCookie(String string) {
        this.cookie = string;
    }

    public final void setExtraInfo(Object object) {
        this.extra_info = object;
    }

    public final void setParams(NVPair[] nVPairArray) {
        this.auth_params = nVPairArray != null ? Util.resizeArray(nVPairArray, nVPairArray.length) : new NVPair[0];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this.scheme);
        stringBuffer.append(" ");
        if (this.cookie != null) {
            stringBuffer.append(this.cookie);
        } else {
            if (this.realm.length() > 0) {
                stringBuffer.append("realm=\"");
                stringBuffer.append(Util.quoteString(this.realm, "\\\""));
                stringBuffer.append('\"');
            }
            int n = 0;
            while (n < this.auth_params.length) {
                stringBuffer.append(',');
                stringBuffer.append(this.auth_params[n].getName());
                stringBuffer.append("=\"");
                stringBuffer.append(Util.quoteString(this.auth_params[n].getValue(), "\\\""));
                stringBuffer.append('\"');
                ++n;
            }
        }
        return stringBuffer.toString();
    }
}

