
// Copyright (C) 1998-1999
// Object Oriented Concepts, Inc.

// **********************************************************************
//
// Copyright (c) 1997
// Mark Spruiell (mark@intellisoft.com)
//
// See the COPYING file for more information
//
// **********************************************************************

package jacorb.trading.client.proxy;

import java.io.*;
import java.util.*;
import org.omg.CORBA.*;

public class ProxyDemo
{
    public static void main(String[] args)
    {
	String iorfile = null;

	int argc = 0;
	while (argc < args.length) {
	    if (args[argc].equals("-i")) {
		argc++;
		if (argc < args.length)
		    iorfile = args[argc];
		else
		    usage();
	    }

	    argc++;
	}

	// initialize the ORB
	ORB orb = ORB.init(args, null);

	// create the proxy lookup implementation
	ProxyLookupImpl impl = new ProxyLookupImpl();

	// write the IOR of the object (if necessary)
	if (iorfile != null) 
	{
	    try 
	    {
		FileOutputStream out = new FileOutputStream(iorfile);
		PrintWriter pw = new PrintWriter(out);
		pw.println(orb.object_to_string(impl._this()));
		pw.flush();
		out.close();
	    }
	    catch (IOException e) {
		System.err.println("Unable to write IOR to file " + iorfile);
		System.exit(1);
	    }
	}
	orb.run();
	System.exit(0);
    }


    protected static void usage()
    {
	System.err.println("Usage: jtdemo.proxy.ProxyDemo [-i iorfile]");
	System.exit(1);
    }
}




