# gawk shell script to modify the domain client stub (_DomainStub.java). call with gawk -f 
# $Id: addPolicyCache.awk,v 1.2 2000/09/08 14:57:50 kiefer Exp $
#The client stub
# is generated by the IDL-compiler. This gawk-script adds the policy cache to the stub.
# The following operations are modified:
# - get_domain_policy
# - set_domain_policy
# - overwrite_domain_policy
# - hasPolicyOfType
# - deletePolicyOfType
# In addition a private reference to the policy cache and a private getter method are added
# at the begin of the method declaration.
BEGIN { 
# counters
  import                  = 0;
  getCache                = 0;
  get_domain_policy       = 0;
  set_domain_policy       = 0;
  overwrite_domain_policy = 0;
  hasPolicyOfType         = 0;
  deletePolicyOfType      = 0;

# code to add

  importCode="\nimport jacorb.util.Debug;\n"

  getCacheCode="\n\
        private PolicyCache thePolicyCache= null;\n\
\n\
        /** returns the policy cache. */\n\
        private PolicyCache getCache()\n\
        {\n\
	  if (thePolicyCache == null) thePolicyCache= new PolicyCache();\n\
	  return thePolicyCache;\n\
	} // getCache";

  get_domain_policyPartOne="\n\
                        // Herb: caching is handmade\n\
		        // get_domain_policy is the only method which updates the cache from the server\n\
                        PolicyCache cache= getCache();\n\
		        org.omg.CORBA.Policy result= cache.read(policy_type);\n\
			if (result != null)\n\
			  {\n\
			    Debug.output(Debug.DOMAIN | Debug.DEBUG1,\"domain client stub.get_domain\"\n\
					 +\"_policy: cache hit\");\n\
			    return result; // cache hit\n\
			  }\n\
\n\
                          Debug.output(Debug.DOMAIN | Debug.DEBUG1, \"domain client stub.get_domain\"\n\
					 +\"_policy: cache miss\");\n\
\n\
			// else cache miss, read form server";

  get_domain_policyPartTwo=" 				cache.write(_result); // Herb: write to cache";

  overwrite_domain_policyCode="\n\
                        getCache().write(policy);\n\
		        // cache write strategy is write-through";


  set_domain_policyCode="\n\
                                // write strategy of policy cache is write-trough\n\
				// write cache after operation invoke\n\
				// so in case of exception no changes to the cache are made\n\
				getCache().write(policy);"; 


  hasPolicyOfType_PartOne="\n\
                        // Herb: caching is handmade\
\n\
                        PolicyCache cache= getCache();\n\
			if ( cache.isValid(type) ) \n\
			  {\n\
			    Debug.output(Debug.DOMAIN | Debug.DEBUG1, \"domain client stub.hasPolicyOfType\"\n\
					 +\": cache hit\");\n\
			    return true; // cache hit\n\
			  }\n\
\n\
                          Debug.output(Debug.DOMAIN | Debug.DEBUG1, \"domain client stub.hasPolicyOfType\"\n\
					 +\": cache miss\");\n\
\n\
			// else cache miss, read form server";


  deletePolicyOfType_PartOne="\n\
				getCache().remove(type); // Herb: added by hand";

                           
}

#import
/package/ { print $0; print importCode; next; }


# getCache()
/implements/, /private/ {  
                                            print $0;
					    if ( getCache == 1) 
					      {
						print getCacheCode;
					      }
					    getCache++; 
					    next;  
					      
}


# get_domain_policy
/Policy get_domain_policy/, /return/ {  
                                            print $0;
					    if ( get_domain_policy == 5) 
					      {
						print  get_domain_policyPartOne;
					      }
					    if ( get_domain_policy == 12) 
					      {
						print  get_domain_policyPartTwo;
					      }
					    get_domain_policy++; 
					    next;  
					      
}


# overwrite_domain_policy
/void overwrite_domain_policy/, /return/ {  
                                            print $0;
					    if (overwrite_domain_policy == 6) 
					      {
						print overwrite_domain_policyCode;
					      }
					    overwrite_domain_policy++; 
					    next;  
					      
}


# set_domain_policy
/void set_domain_policy/, /return/ {  
                                            print $0;
					    if (set_domain_policy == 11) 
					      {
						print set_domain_policyCode;
					      }
					    set_domain_policy++; 
					    next;  
					      
}

# hasPolicyOfType
/boolean hasPolicyOfType/, /InputStream/ {  
                                            print $0;
					    if (hasPolicyOfType == 5) 
					      {
						print hasPolicyOfType_PartOne;
					      }
					    if (hasPolicyOfType == 12) print "hallo2";
					    hasPolicyOfType++; 
					    next;  
					      
}

# deletePolicyOfType
/void deletePolicyOfType/, /return/ {  
                                            print $0;
					    if (deletePolicyOfType == 11) 
					      {
						print deletePolicyOfType_PartOne;
					      }
					    deletePolicyOfType++; 
					    next;  
					      
}

{ print $0 }
