/*
 *        JacORB - a free Java ORB
 *
 *   Copyright (C) 1997-98  Gerald Brose.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jacorb.idl;

/**
 * @author Gerald Brose
 * @version $Id: PosIntConst.java,v 1.6 1999/11/25 16:04:07 brose Exp $ 
 */

class PosIntConst 
	extends IdlSymbol
{
	public ConstExpr const_expr;

	public PosIntConst(int num)
	{
		super(num);
	}

	public void parse() 
		 
	{
		const_expr.parse();
	}

	public int value()
	{
		return const_expr.pos_int_const();
	}


	public String toString()
	{
		return const_expr.toString();
	}


    public void setPackage( String s, boolean propagate_into_included )
    {
        s = parser.pack_replace(s);
	if( pack_name.length() > 0 )
	    pack_name = new String( s + "." + pack_name );
	else
	    pack_name = s;
	const_expr.setPackage(s, propagate_into_included);
    }
}








