/*
 * Decompiled with CFR 0.152.
 */
package jacorb.orb.http;

import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import jacorb.orb.Connection;
import jacorb.orb.ConnectionManager;
import jacorb.orb.ReplyReceptor;
import jacorb.orb.factory.SocketFactory;
import jacorb.orb.giop.LocateReplyInputStream;
import jacorb.orb.giop.LocateRequestOutputStream;
import jacorb.orb.giop.ReplyInputStream;
import jacorb.orb.giop.RequestOutputStream;
import jacorb.util.Debug;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.InputStream;

public final class ClientConnection
extends jacorb.orb.giop.ClientConnection {
    static int counter = 0;
    int mycounter = counter++;
    boolean connected = true;
    java.lang.Object notifier;
    HTTPResponse rsp;
    String host = null;
    int port;

    public ClientConnection(ConnectionManager connectionManager, String string, int n, SocketFactory socketFactory) {
        this.manager = connectionManager;
        this.orb = connectionManager.getORB();
        this.host = string;
        this.port = n;
        this.connection_info = String.valueOf(this.host) + ":" + this.port;
        this.socket_factory = socketFactory;
    }

    protected void abort() throws EOFException {
        Debug.output(3, "HTTPClient Connection " + this.mycounter + " to " + this.connection_info + " aborting...->Ex");
        Enumeration enumeration = this.replies.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            ReplyInputStream replyInputStream = (ReplyInputStream)this.replies.get(enumeration.nextElement());
            replyInputStream.cancel();
            ++n;
        }
        this.replies.clear();
        this.buffers.clear();
        this.objects.clear();
        if (n > 0) {
            Debug.output(2, "Lost " + n + " outstanding replies");
        }
        throw new EOFException();
    }

    public synchronized void closeConnection() {
        this.manager.removeConnection(this);
        this.connected = false;
    }

    public boolean connected() {
        return true;
    }

    public Hashtable get_buffers() {
        return this.buffers;
    }

    public Hashtable get_objects() {
        return this.objects;
    }

    public Hashtable get_replies() {
        return this.replies;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized byte[] readBuffer() throws IOException {
        while (this.repReceptor == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        java.lang.Object object = this.notifier;
        synchronized (object) {
            while (this.rsp == null) {
                try {
                    this.notifier.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        try {
            this.in_stream = new BufferedInputStream(this.rsp.getInputStream());
            return super.readBuffer();
        }
        catch (Exception exception) {
            Debug.output(1, "This is a Client->Server HTTP Connection. ReadBuffer calls can only be done after some send call+receiveReply()");
        }
        return super.readBuffer();
    }

    public synchronized void reconnect() throws COMM_FAILURE {
        Debug.output(1, "Trying to reconnect to " + this.connection_info);
    }

    public LocateReplyInputStream sendLocateRequest(LocateRequestOutputStream locateRequestOutputStream) throws COMM_FAILURE {
        java.lang.Object object = this.writeLock;
        synchronized (object) {
            LocateReplyInputStream locateReplyInputStream = null;
            try {
                this.rsp = null;
                this.notifier = new java.lang.Object();
                this.repReceptor = new ReplyReceptor(this, true);
                byte[] byArray = locateRequestOutputStream.getBufferCopy();
                locateReplyInputStream = new LocateReplyInputStream((Connection)this, locateRequestOutputStream.requestId());
                Integer n = new Integer(locateRequestOutputStream.requestId());
                this.buffers.put(n, locateRequestOutputStream);
                this.replies.put(n, locateReplyInputStream);
                java.lang.Object object2 = this.notifier;
                synchronized (object2) {
                    HTTPConnection hTTPConnection = new HTTPConnection("http://" + this.host + ":" + this.port);
                    this.rsp = hTTPConnection.Post("", byArray);
                    Thread.yield();
                    this.notifier.notifyAll();
                }
            }
            catch (Exception exception) {
                Debug.output(2, exception);
                throw new COMM_FAILURE();
            }
            LocateReplyInputStream locateReplyInputStream2 = locateReplyInputStream;
            java.lang.Object var4_10 = null;
            return locateReplyInputStream2;
        }
    }

    public InputStream sendRequest(Object object, RequestOutputStream requestOutputStream) throws COMM_FAILURE {
        java.lang.Object object2 = this.writeLock;
        synchronized (object2) {
            ReplyInputStream replyInputStream = null;
            try {
                java.lang.Object object3;
                this.rsp = null;
                this.notifier = new java.lang.Object();
                this.repReceptor = new ReplyReceptor(this, true);
                int n = -1;
                byte[] byArray = requestOutputStream.getBufferCopy();
                n = byArray.length;
                if (requestOutputStream.response_expected()) {
                    replyInputStream = new ReplyInputStream((Connection)this, requestOutputStream.requestId());
                    object3 = new Integer(requestOutputStream.requestId());
                    this.buffers.put(object3, requestOutputStream);
                    this.replies.put(object3, replyInputStream);
                    this.objects.put(object3, object);
                }
                object3 = this.notifier;
                synchronized (object3) {
                    HTTPConnection hTTPConnection = new HTTPConnection(new URL("http://" + this.host + ":" + this.port));
                    this.rsp = hTTPConnection.Post("", byArray);
                    Thread.yield();
                    this.notifier.notifyAll();
                }
            }
            catch (Exception exception) {
                Debug.output(2, exception);
                throw new COMM_FAILURE();
            }
            ReplyInputStream replyInputStream2 = replyInputStream;
            java.lang.Object var5_11 = null;
            return replyInputStream2;
        }
    }

    public void setTimeOut(int n) throws SocketException {
    }

    public void writeDirectly(byte[] byArray, int n) throws IOException {
        java.lang.Object object = this.writeLock;
        synchronized (object) {
            Debug.output(2, "Sending request with writeDirectly");
            try {
                this.notifier = new java.lang.Object();
                this.repReceptor = new ReplyReceptor(this, true);
                byte[] byArray2 = new byte[n];
                System.arraycopy(byArray, 0, byArray2, 0, n);
                int n2 = n;
                java.lang.Object object2 = this.notifier;
                synchronized (object2) {
                    HTTPConnection hTTPConnection = new HTTPConnection(new URL("http://" + this.host + ":" + this.port));
                    this.rsp = hTTPConnection.Post("", byArray2);
                    Thread.yield();
                    this.notifier.notifyAll();
                }
            }
            catch (Exception exception) {
                Debug.output(2, exception);
                throw new COMM_FAILURE();
            }
        }
    }
}

