/*
 * Decompiled with CFR 0.152.
 */
package jacorb.orb;

import jacorb.orb.CDRInputStream;
import jacorb.orb.CDROutputStream;
import jacorb.orb.Delegate;
import jacorb.orb.ORB;
import jacorb.orb.util.CorbaLoc;
import jacorb.util.Debug;
import jacorb.util.ObjectUtil;
import java.io.ByteArrayOutputStream;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.Object;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.IIOP.ProfileBody_1_0;
import org.omg.IIOP.ProfileBody_1_0Helper;
import org.omg.IIOP.ProfileBody_1_1;
import org.omg.IIOP.ProfileBody_1_1Helper;
import org.omg.IIOP.VersionHelper;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.omg.IOP.MultipleComponentProfileHelper;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedProfile;
import org.omg.SSLIOP.SSL;
import org.omg.SSLIOP.SSLHelper;

public class ParsedIOR {
    protected ProfileBody_1_1 profileBody = null;
    protected TaggedProfile effective_profile = null;
    protected String object_key_str = null;
    protected boolean endianness = false;
    protected String ior_str = null;
    protected IOR ior = null;
    protected byte[] object_key;
    private ORB orb;
    protected TaggedComponent[] taggedComponents = new TaggedComponent[0];

    public ParsedIOR(String string) {
        this.parse(string);
    }

    public ParsedIOR(String string, ORB oRB) {
        this.orb = oRB;
        this.parse(string);
    }

    public ParsedIOR(IOR iOR) {
        this.decode(iOR);
    }

    public static IOR createIOR(String string, ProfileBody_1_0 profileBody_1_0) {
        IOR iOR = new IOR();
        iOR.type_id = string;
        iOR.profiles = new TaggedProfile[1];
        iOR.profiles[0] = new TaggedProfile();
        iOR.profiles[0].tag = 0;
        CDROutputStream cDROutputStream = new CDROutputStream();
        cDROutputStream.write_boolean(false);
        ProfileBody_1_0Helper.write(cDROutputStream, profileBody_1_0);
        iOR.profiles[0].profile_data = cDROutputStream.getBufferCopy();
        return iOR;
    }

    public void decode(CorbaLoc corbaLoc) {
        IOR iOR = null;
        CorbaLoc.ObjectAddress objectAddress = corbaLoc.objectAddressList[0];
        if (objectAddress.protocol_identifier.equals("rir")) {
            try {
                Object object = this.orb.resolve_initial_references(corbaLoc.getKeyString());
                iOR = ((Delegate)((ObjectImpl)object)._get_delegate()).getIOR();
            }
            catch (Exception exception) {
                Debug.output(2, exception);
                throw new IllegalArgumentException("Invalid corbaloc: URL");
            }
        } else if (objectAddress.protocol_identifier.equals("iiop")) {
            ProfileBody_1_0 profileBody_1_0 = new ProfileBody_1_0(objectAddress.getVersion(), objectAddress.host, (short)objectAddress.port, corbaLoc.getKey());
            iOR = ParsedIOR.createIOR("IDL:org.omg/CORBA/Object:1.0", profileBody_1_0);
        }
        this.decode(iOR);
    }

    public void decode(IOR iOR) {
        boolean bl = false;
        int n = 0;
        while (n < iOR.profiles.length) {
            Debug.output(4, "Parsing IOR, found profile id: " + iOR.profiles[n].tag);
            switch (iOR.profiles[n].tag) {
                case 1: {
                    Debug.output(4, "TAG_MULTIPLE_COMPONENTS found in IOR");
                    CDRInputStream cDRInputStream = new CDRInputStream(null, iOR.profiles[n].profile_data);
                    cDRInputStream.setLittleEndian(cDRInputStream.read_boolean());
                    this.decode_MULTIPLE_COMPONENTS_profile(MultipleComponentProfileHelper.read(cDRInputStream));
                    break;
                }
                case 0: {
                    Debug.output(4, "TAG_INTERNET_IOP found in IOR");
                    if (this.decode_INTERNET_IOP_profile(iOR.profiles[n].profile_data)) {
                        this.effective_profile = iOR.profiles[n];
                    }
                    bl = true;
                    break;
                }
            }
            ++n;
        }
        if (!bl && iOR.profiles.length > 0) {
            throw new INV_OBJREF("no TAG_INTERNET_IOP found in object_reference");
        }
        this.ior = iOR;
        this.ior_str = this.getIORString();
    }

    protected boolean decode_INTERNET_IOP_profile(byte[] byArray) {
        ProfileBody_1_1 profileBody_1_1 = ParsedIOR.getProfileBody(byArray, this.profileBody != null ? (int)this.profileBody.iiop_version.minor : 0);
        boolean bl = false;
        if (profileBody_1_1 != null) {
            this.profileBody = profileBody_1_1;
            bl = true;
        }
        this.decode_MULTIPLE_COMPONENTS_profile(this.profileBody.components);
        Debug.output(4, "IOP 1.1 decoded");
        this.object_key_str = new String(this.profileBody.object_key);
        this.object_key = this.profileBody.object_key;
        return bl;
    }

    protected void decode_MULTIPLE_COMPONENTS_profile(TaggedComponent[] taggedComponentArray) {
        TaggedComponent[] taggedComponentArray2 = new TaggedComponent[this.taggedComponents.length + taggedComponentArray.length];
        System.arraycopy(this.taggedComponents, 0, taggedComponentArray2, 0, this.taggedComponents.length);
        System.arraycopy(taggedComponentArray, 0, taggedComponentArray2, this.taggedComponents.length, taggedComponentArray.length);
        this.taggedComponents = taggedComponentArray2;
    }

    public String getAddress() {
        int n = this.profileBody.port;
        if (n < 0) {
            n += 65536;
        }
        return String.valueOf(this.profileBody.host) + ":" + n;
    }

    public TaggedProfile getEffectiveProfile() {
        return this.effective_profile;
    }

    public IOR getIOR() {
        return this.ior;
    }

    public String getIORString() {
        if (this.ior_str == null) {
            try {
                CDROutputStream cDROutputStream = new CDROutputStream();
                cDROutputStream.write_boolean(false);
                IORHelper.write(cDROutputStream, this.ior);
                byte[] byArray = cDROutputStream.getBufferCopy();
                StringBuffer stringBuffer = new StringBuffer("IOR:");
                int n = 0;
                while (n < byArray.length) {
                    int n2 = byArray[n];
                    if (n2 < 0) {
                        n2 += 256;
                    }
                    int n3 = (0xFF & n2) / 16;
                    int n4 = (0xFF & n2) % 16;
                    int n5 = n3 < 10 ? 48 + n3 : 97 + (n3 - 10);
                    int n6 = n4 < 10 ? 48 + n4 : 97 + (n4 - 10);
                    stringBuffer.append((char)n5);
                    stringBuffer.append((char)n6);
                    ++n;
                }
                this.ior_str = stringBuffer.toString();
            }
            catch (Exception exception) {
                Debug.output(2, exception);
                throw new UNKNOWN("Error in building IIOP-IOR");
            }
        }
        return this.ior_str;
    }

    public String getObjKey() {
        return this.object_key_str;
    }

    public ProfileBody_1_1 getProfileBody() {
        return this.profileBody;
    }

    public static ProfileBody_1_1 getProfileBody(byte[] byArray, int n) {
        ProfileBody_1_1 profileBody_1_1 = null;
        CDRInputStream cDRInputStream = new CDRInputStream(null, byArray);
        try {
            cDRInputStream.setLittleEndian(cDRInputStream.read_boolean());
            cDRInputStream.mark(0);
            byte by = VersionHelper.read((InputStream)cDRInputStream).minor;
            if (by < n || by > 2) {
                return null;
            }
            cDRInputStream.reset();
            switch (by) {
                case 1: 
                case 2: {
                    profileBody_1_1 = ProfileBody_1_1Helper.read(cDRInputStream);
                    break;
                }
                case 0: {
                    ProfileBody_1_0 profileBody_1_0 = ProfileBody_1_0Helper.read(cDRInputStream);
                    profileBody_1_1 = new ProfileBody_1_1(profileBody_1_0.iiop_version, profileBody_1_0.host, profileBody_1_0.port, profileBody_1_0.object_key, new TaggedComponent[0]);
                    if (profileBody_1_1.port < 0) {
                        profileBody_1_1.port = (short)(profileBody_1_1.port + 65536);
                    }
                    break;
                }
                default: {
                    return profileBody_1_1;
                }
            }
        }
        catch (Exception exception) {
            Debug.output(2, exception);
            throw new INV_OBJREF();
        }
        return profileBody_1_1;
    }

    public static SSL getSSLTaggedComponent(ProfileBody_1_1 profileBody_1_1) {
        if (profileBody_1_1 == null || (char)profileBody_1_1.iiop_version.minor == '\u0000' || profileBody_1_1.components == null) {
            return null;
        }
        boolean bl = false;
        int n = 0;
        while (n < profileBody_1_1.components.length) {
            if (profileBody_1_1.components[n].tag == 20) {
                bl = true;
                CDRInputStream cDRInputStream = new CDRInputStream(null, profileBody_1_1.components[n].component_data);
                try {
                    cDRInputStream.openEncapsulation();
                    return SSLHelper.read(cDRInputStream);
                }
                catch (Exception exception) {
                    return null;
                }
            }
            ++n;
        }
        return null;
    }

    public static SSL getSSLTaggedComponent(TaggedComponent[] taggedComponentArray) {
        boolean bl = false;
        int n = 0;
        while (n < taggedComponentArray.length) {
            if (taggedComponentArray[n].tag == 20) {
                bl = true;
                CDRInputStream cDRInputStream = new CDRInputStream(null, taggedComponentArray[n].component_data);
                try {
                    cDRInputStream.openEncapsulation();
                    return SSLHelper.read(cDRInputStream);
                }
                catch (Exception exception) {
                    return null;
                }
            }
            ++n;
        }
        return null;
    }

    public String getTypeId() {
        return this.ior.type_id;
    }

    public byte[] get_object_key() {
        return this.object_key;
    }

    public boolean isNull() {
        return this.ior.type_id.equals("") && this.ior.profiles.length == 0;
    }

    protected void parse(String string) {
        if (string.startsWith("IOR:")) {
            this.ior_str = string;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = (string.length() - 4) / 2;
            int n2 = 0;
            while (n2 < n) {
                int n3;
                char c = string.charAt(n2 * 2 + 4);
                char c2 = string.charAt(n2 * 2 + 5);
                int n4 = c >= 'a' ? 10 + c - 97 : (n3 = c >= 'A' ? 10 + c - 65 : c - 48);
                int n5 = c2 >= 'a' ? 10 + c2 - 97 : (c2 >= 'A' ? 10 + c2 - 65 : c2 - 48);
                byteArrayOutputStream.write(n3 * 16 + n5);
                ++n2;
            }
            CDRInputStream cDRInputStream = new CDRInputStream(org.omg.CORBA.ORB.init(), byteArrayOutputStream.toByteArray());
            this.endianness = cDRInputStream.read_boolean();
            if (this.endianness) {
                cDRInputStream.setLittleEndian(true);
            }
            IOR iOR = IORHelper.read(cDRInputStream);
            this.decode(iOR);
        } else if (string.startsWith("corbaloc:")) {
            this.decode(new CorbaLoc(string));
        } else if (string.startsWith("http://") || string.startsWith("file:/")) {
            this.parse(ObjectUtil.readURL(string));
        } else if (string.startsWith("corbaname:")) {
            String string2;
            String string3 = "";
            if (string.indexOf(35) == -1) {
                string2 = "corbaloc:" + string.substring(string.indexOf(58) + 1);
            } else {
                string2 = "corbaloc:" + string.substring(string.indexOf(58) + 1, string.indexOf(35));
                string3 = string.substring(string.indexOf(35) + 1);
            }
            if (string2.indexOf(47) == -1) {
                string2 = String.valueOf(string2) + "/NameService";
            }
            Debug.output(4, string2);
            try {
                NamingContextExt namingContextExt = NamingContextExtHelper.narrow(this.orb.string_to_object(string2));
                Object object = namingContextExt.resolve_str(string3);
                IOR iOR = ((Delegate)((ObjectImpl)object)._get_delegate()).getIOR();
                this.decode(iOR);
            }
            catch (Exception exception) {
                Debug.output(4, exception);
                throw new RuntimeException("Invalid object reference: " + string);
            }
        } else {
            throw new RuntimeException("Invalid IOR format: " + string);
        }
    }
}

