/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.ParseException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.BitSet;

public class URI {
    protected static BitSet alphanumChar = new BitSet(128);
    protected static BitSet markChar;
    protected static BitSet reservedChar;
    protected static BitSet unreservedChar;
    protected static BitSet uricChar;
    protected static BitSet pcharChar;
    protected static BitSet userinfoChar;
    protected static BitSet schemeChar;
    protected static BitSet reg_nameChar;
    protected boolean is_generic;
    protected String scheme;
    protected String opaque;
    protected String userinfo;
    protected String host;
    protected int port;
    protected String path;
    protected String query;
    protected String fragment;
    protected URL url;
    private static final char[] hex;

    static {
        int n = 48;
        while (n <= 57) {
            alphanumChar.set(n);
            ++n;
        }
        int n2 = 65;
        while (n2 <= 90) {
            alphanumChar.set(n2);
            ++n2;
        }
        int n3 = 97;
        while (n3 <= 122) {
            alphanumChar.set(n3);
            ++n3;
        }
        markChar = new BitSet(128);
        markChar.set(45);
        markChar.set(95);
        markChar.set(46);
        markChar.set(33);
        markChar.set(126);
        markChar.set(42);
        markChar.set(39);
        markChar.set(40);
        markChar.set(41);
        reservedChar = new BitSet(128);
        reservedChar.set(59);
        reservedChar.set(47);
        reservedChar.set(63);
        reservedChar.set(58);
        reservedChar.set(64);
        reservedChar.set(38);
        reservedChar.set(61);
        reservedChar.set(43);
        reservedChar.set(36);
        reservedChar.set(44);
        unreservedChar = new BitSet(128);
        unreservedChar.or(alphanumChar);
        unreservedChar.or(markChar);
        uricChar = new BitSet(128);
        uricChar.or(unreservedChar);
        uricChar.or(reservedChar);
        pcharChar = new BitSet(128);
        pcharChar.or(unreservedChar);
        pcharChar.set(58);
        pcharChar.set(64);
        pcharChar.set(38);
        pcharChar.set(61);
        pcharChar.set(43);
        pcharChar.set(36);
        pcharChar.set(44);
        userinfoChar = new BitSet(128);
        userinfoChar.or(unreservedChar);
        userinfoChar.set(59);
        userinfoChar.set(58);
        userinfoChar.set(38);
        userinfoChar.set(61);
        userinfoChar.set(43);
        userinfoChar.set(36);
        userinfoChar.set(44);
        schemeChar = new BitSet(128);
        schemeChar.or(alphanumChar);
        schemeChar.set(43);
        schemeChar.set(45);
        schemeChar.set(46);
        reg_nameChar = new BitSet(128);
        reg_nameChar.or(unreservedChar);
        reg_nameChar.set(36);
        reg_nameChar.set(44);
        reg_nameChar.set(59);
        reg_nameChar.set(58);
        reg_nameChar.set(64);
        reg_nameChar.set(38);
        reg_nameChar.set(61);
        reg_nameChar.set(43);
        hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }

    public URI(URI uRI, String string) throws ParseException {
        block26: {
            this.port = -1;
            this.url = null;
            char[] cArray = string.toCharArray();
            int n = 0;
            int n2 = cArray.length;
            while (n < n2 && Character.isSpace(cArray[n])) {
                ++n;
            }
            while (n2 > 0 && Character.isSpace(cArray[n2 - 1])) {
                --n2;
            }
            if (!(n >= n2 - 3 || cArray[n + 3] != ':' || cArray[n] != 'u' && cArray[n] != 'U' || cArray[n + 1] != 'r' && cArray[n + 1] != 'R' || cArray[n + 2] != 'i' && cArray[n + 2] != 'I' && cArray[n + 2] != 'l' && cArray[n + 2] != 'L')) {
                n += 4;
            }
            int n3 = n;
            while (n3 < n2 && cArray[n3] != ':' && cArray[n3] != '/' && cArray[n3] != '?' && cArray[n3] != '#') {
                ++n3;
            }
            if (n3 < n2 && cArray[n3] == ':') {
                this.scheme = string.substring(n, n3).trim().toLowerCase();
                n = n3 + 1;
            }
            String string2 = this.scheme;
            if (this.scheme == null) {
                if (uRI == null) {
                    throw new ParseException("No scheme found");
                }
                string2 = uRI.scheme;
            }
            this.is_generic = URI.usesGenericSyntax(string2);
            if (!this.is_generic) {
                if (uRI != null && this.scheme == null) {
                    throw new ParseException("Can't resolve relative URI for scheme " + string2);
                }
                this.opaque = string.substring(n);
                return;
            }
            if (n < n2 - 1 && cArray[n] == '/' && cArray[n + 1] == '/') {
                n3 = n += 2;
                while (n3 < n2 && cArray[n3] != '/' && cArray[n3] != '?' && cArray[n3] != '#') {
                    ++n3;
                }
                this.parse_authority(string.substring(n, n3), string2);
                n = n3;
            }
            n3 = n;
            while (n3 < n2 && cArray[n3] != '?' && cArray[n3] != '#') {
                ++n3;
            }
            this.path = string.substring(n, n3);
            n = n3;
            if (n < n2 && cArray[n] == '?') {
                n3 = ++n;
                while (n3 < n2 && cArray[n3] != '#') {
                    ++n3;
                }
                this.query = URI.unescape(string.substring(n, n3));
                n = n3;
            }
            if (n < n2 && cArray[n] == '#') {
                this.fragment = URI.unescape(string.substring(n + 1, n2));
            }
            if (uRI == null) break block26;
            if (this.scheme != null) {
                return;
            }
            this.scheme = uRI.scheme;
            if (this.host != null) {
                return;
            }
            this.userinfo = uRI.userinfo;
            this.host = uRI.host;
            this.port = uRI.port;
            if (this.path.length() == 0 && this.query == null) {
                this.path = uRI.path;
                this.query = uRI.query;
                return;
            }
            if (this.path.length() != 0 && this.path.charAt(0) == '/') break block26;
            n3 = uRI.path.lastIndexOf(47);
            if (n3 == -1) {
                return;
            }
            this.path = String.valueOf(uRI.path.substring(0, n3 + 1)) + this.path;
            n2 = this.path.length();
            n3 = this.path.indexOf("/.");
            if (n3 == -1 || n3 != n2 - 2 && this.path.charAt(n3 + 2) != '/' && (this.path.charAt(n3 + 2) != '.' || n3 != n2 - 3 && this.path.charAt(n3 + 3) != '/')) {
                return;
            }
            char[] cArray2 = new char[this.path.length()];
            this.path.getChars(0, cArray2.length, cArray2, 0);
            int n4 = 0;
            n3 = 1;
            while (n3 < n2) {
                block27: {
                    int n5;
                    block29: {
                        block31: {
                            block30: {
                                block28: {
                                    if (cArray2[n3] != '.' || cArray2[n3 - 1] != '/') break block27;
                                    if (n3 != n2 - 1) break block28;
                                    n5 = n3++;
                                    break block29;
                                }
                                if (cArray2[n3 + 1] != '/') break block30;
                                n5 = n3 - 1;
                                ++n3;
                                break block29;
                            }
                            if (cArray2[n3 + 1] != '.' || n3 != n2 - 2 && cArray2[n3 + 2] != '/') break block27;
                            if (n3 >= n4 + 2) break block31;
                            n4 = n3 + 2;
                            break block27;
                        }
                        n5 = n3 - 2;
                        while (n5 > n4 && cArray2[n5] != '/') {
                            --n5;
                        }
                        if (cArray2[n5] != '/') break block27;
                        if (n3 == n2 - 2) {
                            ++n5;
                        }
                        n3 += 2;
                    }
                    System.arraycopy(cArray2, n3, cArray2, n5, n2 - n3);
                    n2 -= n3 - n5;
                    n3 = n5;
                }
                ++n3;
            }
            this.path = new String(cArray2, 0, n2);
        }
    }

    public URI(String string) throws ParseException {
        this((URI)null, string);
    }

    public URI(String string, String string2) throws ParseException {
        this.port = -1;
        this.url = null;
        if (string == null) {
            throw new ParseException("missing scheme");
        }
        this.scheme = string.trim().toLowerCase();
        this.opaque = string2;
        this.is_generic = false;
    }

    public URI(String string, String string2, int n, String string3) throws ParseException {
        this(string, null, string2, n, string3, null, null);
    }

    public URI(String string, String string2, String string3) throws ParseException {
        this(string, null, string2, -1, string3, null, null);
    }

    public URI(String string, String string2, String string3, int n, String string4, String string5, String string6) throws ParseException {
        this.port = -1;
        this.url = null;
        if (string == null) {
            throw new ParseException("missing scheme");
        }
        this.scheme = string.trim().toLowerCase();
        if (string2 != null) {
            this.userinfo = URI.unescape(string2.trim());
        }
        if (string3 != null) {
            this.host = string3.trim();
        }
        if (n != URI.defaultPort(string)) {
            this.port = n;
        }
        if (string4 != null) {
            this.path = string4.trim();
        }
        if (string5 != null) {
            this.query = string5.trim();
        }
        if (string6 != null) {
            this.fragment = string6.trim();
        }
        this.is_generic = true;
    }

    public URI(URL uRL) throws ParseException {
        this((URI)null, uRL.toExternalForm());
    }

    public static final int defaultPort(String string) {
        String string2 = string.trim();
        if (string2.equalsIgnoreCase("http") || string2.equalsIgnoreCase("shttp") || string2.equalsIgnoreCase("http-ng") || string2.equalsIgnoreCase("coffee")) {
            return 80;
        }
        if (string2.equalsIgnoreCase("https")) {
            return 443;
        }
        if (string2.equalsIgnoreCase("ftp")) {
            return 21;
        }
        if (string2.equalsIgnoreCase("telnet")) {
            return 23;
        }
        if (string2.equalsIgnoreCase("nntp") || string2.equalsIgnoreCase("news")) {
            return 119;
        }
        if (string2.equalsIgnoreCase("snews")) {
            return 563;
        }
        if (string2.equalsIgnoreCase("hnews")) {
            return 80;
        }
        if (string2.equalsIgnoreCase("smtp")) {
            return 25;
        }
        if (string2.equalsIgnoreCase("gopher")) {
            return 70;
        }
        if (string2.equalsIgnoreCase("wais")) {
            return 210;
        }
        if (string2.equalsIgnoreCase("whois")) {
            return 43;
        }
        if (string2.equalsIgnoreCase("whois++")) {
            return 63;
        }
        if (string2.equalsIgnoreCase("rwhois")) {
            return 4321;
        }
        if (string2.equalsIgnoreCase("imap")) {
            return 143;
        }
        if (string2.equalsIgnoreCase("pop")) {
            return 110;
        }
        if (string2.equalsIgnoreCase("prospero")) {
            return 1525;
        }
        if (string2.equalsIgnoreCase("irc")) {
            return 194;
        }
        if (string2.equalsIgnoreCase("ldap")) {
            return 389;
        }
        if (string2.equalsIgnoreCase("nfs")) {
            return 2049;
        }
        if (string2.equalsIgnoreCase("z39.50r") || string2.equalsIgnoreCase("z39.50s")) {
            return 210;
        }
        if (string2.equalsIgnoreCase("vemmi")) {
            return 575;
        }
        if (string2.equalsIgnoreCase("videotex")) {
            return 516;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object instanceof URI) {
            URI uRI = (URI)object;
            return this.scheme.equals(uRI.scheme) && (!this.is_generic && (this.opaque == null && uRI.opaque == null || this.opaque != null && uRI.opaque != null && this.opaque.equals(uRI.opaque)) || this.is_generic && (this.userinfo == null && uRI.userinfo == null || this.userinfo != null && uRI.userinfo != null && this.userinfo.equals(uRI.userinfo)) && (this.host == null && uRI.host == null || this.host != null && uRI.host != null && this.host.equalsIgnoreCase(uRI.host)) && this.port == uRI.port && (this.path == null && uRI.path == null || this.path != null && uRI.path != null && URI.unescapeNoPE(this.path).equals(URI.unescapeNoPE(uRI.path))) && (this.query == null && uRI.query == null || this.query != null && uRI.query != null && URI.unescapeNoPE(this.query).equals(URI.unescapeNoPE(uRI.query))) && (this.fragment == null && uRI.fragment == null || this.fragment != null && uRI.fragment != null && URI.unescapeNoPE(this.fragment).equals(URI.unescapeNoPE(uRI.fragment))));
        }
        if (object instanceof URL) {
            URL uRL = (URL)object;
            String string = this.userinfo != null ? String.valueOf(this.userinfo) + "@" + this.host : this.host;
            String string2 = this.query != null ? String.valueOf(this.path) + "?" + this.query : this.path;
            return this.scheme.equalsIgnoreCase(uRL.getProtocol()) && (!this.is_generic && this.opaque.equals(uRL.getFile()) || this.is_generic && (string == null && uRL.getHost() == null || string != null && uRL.getHost() != null && string.equalsIgnoreCase(uRL.getHost())) && (this.port == uRL.getPort() || uRL.getPort() == URI.defaultPort(this.scheme)) && (string2 == null && uRL.getFile() == null || string2 != null && uRL.getFile() != null && URI.unescapeNoPE(string2).equals(URI.unescapeNoPE(uRL.getFile()))) && (this.fragment == null && uRL.getRef() == null || this.fragment != null && uRL.getRef() != null && URI.unescapeNoPE(this.fragment).equals(URI.unescapeNoPE(uRL.getRef()))));
        }
        return false;
    }

    private static char[] escape(char[] cArray, BitSet bitSet) {
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            if (!bitSet.get(cArray[n2])) {
                ++n;
            }
            ++n2;
        }
        if (n == 0) {
            return cArray;
        }
        char[] cArray2 = new char[cArray.length + 2 * n];
        int n3 = 0;
        int n4 = 0;
        while (n3 < cArray.length) {
            if (bitSet.get(cArray[n3])) {
                cArray2[n4] = cArray[n3];
            } else {
                if (cArray[n3] > '\u00ff') {
                    throw new RuntimeException("Can't handle non 8-bt chars");
                }
                cArray2[n4++] = 37;
                cArray2[n4++] = hex[cArray[n3] >> 4 & 0xF];
                cArray2[n4] = hex[cArray[n3] & 0xF];
            }
            ++n3;
            ++n4;
        }
        return cArray2;
    }

    public String getFragment() {
        return this.fragment;
    }

    public String getHost() {
        return this.host;
    }

    public String getOpaque() {
        return this.opaque;
    }

    public String getPath() {
        if (this.query != null) {
            if (this.path != null) {
                return String.valueOf(this.path) + "?" + this.query;
            }
            return "?" + this.query;
        }
        return this.path;
    }

    public int getPort() {
        return this.port;
    }

    public String getQueryString() {
        return this.query;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getUserinfo() {
        return this.userinfo;
    }

    public boolean isGenericURI() {
        return this.is_generic;
    }

    public static void main(String[] stringArray) throws Exception {
        System.err.println();
        System.err.println("*** URI Tests ...");
        URI uRI = new URI("http://a/b/c/d;p?q");
        URI.testParser(uRI, "g:h", "g:h");
        URI.testParser(uRI, "g", "http://a/b/c/g");
        URI.testParser(uRI, "./g", "http://a/b/c/g");
        URI.testParser(uRI, "g/", "http://a/b/c/g/");
        URI.testParser(uRI, "/g", "http://a/g");
        URI.testParser(uRI, "//g", "http://g");
        URI.testParser(uRI, "?y", "http://a/b/c/?y");
        URI.testParser(uRI, "g?y", "http://a/b/c/g?y");
        URI.testParser(uRI, "#s", "http://a/b/c/d;p?q#s");
        URI.testParser(uRI, "g#s", "http://a/b/c/g#s");
        URI.testParser(uRI, "g?y#s", "http://a/b/c/g?y#s");
        URI.testParser(uRI, ";x", "http://a/b/c/;x");
        URI.testParser(uRI, "g;x", "http://a/b/c/g;x");
        URI.testParser(uRI, "g;x?y#s", "http://a/b/c/g;x?y#s");
        URI.testParser(uRI, ".", "http://a/b/c/");
        URI.testParser(uRI, "./", "http://a/b/c/");
        URI.testParser(uRI, "..", "http://a/b/");
        URI.testParser(uRI, "../", "http://a/b/");
        URI.testParser(uRI, "../g", "http://a/b/g");
        URI.testParser(uRI, "../..", "http://a/");
        URI.testParser(uRI, "../../", "http://a/");
        URI.testParser(uRI, "../../g", "http://a/g");
        URI.testParser(uRI, "", "http://a/b/c/d;p?q");
        URI.testParser(uRI, "/./g", "http://a/./g");
        URI.testParser(uRI, "/../g", "http://a/../g");
        URI.testParser(uRI, "../../../g", "http://a/../g");
        URI.testParser(uRI, "../../../../g", "http://a/../../g");
        URI.testParser(uRI, "g.", "http://a/b/c/g.");
        URI.testParser(uRI, ".g", "http://a/b/c/.g");
        URI.testParser(uRI, "g..", "http://a/b/c/g..");
        URI.testParser(uRI, "..g", "http://a/b/c/..g");
        URI.testParser(uRI, "./../g", "http://a/b/g");
        URI.testParser(uRI, "./g/.", "http://a/b/c/g/");
        URI.testParser(uRI, "g/./h", "http://a/b/c/g/h");
        URI.testParser(uRI, "g/../h", "http://a/b/c/h");
        URI.testParser(uRI, "g;x=1/./y", "http://a/b/c/g;x=1/y");
        URI.testParser(uRI, "g;x=1/../y", "http://a/b/c/y");
        URI.testParser(uRI, "g?y/./x", "http://a/b/c/g?y/./x");
        URI.testParser(uRI, "g?y/../x", "http://a/b/c/g?y/../x");
        URI.testParser(uRI, "g#s/./x", "http://a/b/c/g#s/./x");
        URI.testParser(uRI, "g#s/../x", "http://a/b/c/g#s/../x");
        URI.testParser(uRI, "http:g", "http:g");
        URI.testParser(uRI, "http:", "http:");
        URI.testParser(uRI, "./g:h", "http://a/b/c/g:h");
        uRI = new URI("http://a/b/c/d;p?q=1/2");
        URI.testParser(uRI, "g", "http://a/b/c/g");
        URI.testParser(uRI, "./g", "http://a/b/c/g");
        URI.testParser(uRI, "g/", "http://a/b/c/g/");
        URI.testParser(uRI, "/g", "http://a/g");
        URI.testParser(uRI, "//g", "http://g");
        URI.testParser(uRI, "?y", "http://a/b/c/?y");
        URI.testParser(uRI, "g?y", "http://a/b/c/g?y");
        URI.testParser(uRI, "g?y/./x", "http://a/b/c/g?y/./x");
        URI.testParser(uRI, "g?y/../x", "http://a/b/c/g?y/../x");
        URI.testParser(uRI, "g#s", "http://a/b/c/g#s");
        URI.testParser(uRI, "g#s/./x", "http://a/b/c/g#s/./x");
        URI.testParser(uRI, "g#s/../x", "http://a/b/c/g#s/../x");
        URI.testParser(uRI, "./", "http://a/b/c/");
        URI.testParser(uRI, "../", "http://a/b/");
        URI.testParser(uRI, "../g", "http://a/b/g");
        URI.testParser(uRI, "../../", "http://a/");
        URI.testParser(uRI, "../../g", "http://a/g");
        uRI = new URI("http://a/b/c/d;p=1/2?q");
        URI.testParser(uRI, "g", "http://a/b/c/d;p=1/g");
        URI.testParser(uRI, "./g", "http://a/b/c/d;p=1/g");
        URI.testParser(uRI, "g/", "http://a/b/c/d;p=1/g/");
        URI.testParser(uRI, "g?y", "http://a/b/c/d;p=1/g?y");
        URI.testParser(uRI, ";x", "http://a/b/c/d;p=1/;x");
        URI.testParser(uRI, "g;x", "http://a/b/c/d;p=1/g;x");
        URI.testParser(uRI, "g;x=1/./y", "http://a/b/c/d;p=1/g;x=1/y");
        URI.testParser(uRI, "g;x=1/../y", "http://a/b/c/d;p=1/y");
        URI.testParser(uRI, "./", "http://a/b/c/d;p=1/");
        URI.testParser(uRI, "../", "http://a/b/c/");
        URI.testParser(uRI, "../g", "http://a/b/c/g");
        URI.testParser(uRI, "../../", "http://a/b/");
        URI.testParser(uRI, "../../g", "http://a/b/g");
        uRI = new URI("fred:///s//a/b/c");
        URI.testParser(uRI, "g:h", "g:h");
        URI.testPE(uRI, "g");
        uRI = new URI("http:///s//a/b/c");
        URI.testParser(uRI, "g:h", "g:h");
        URI.testParser(uRI, "g", "http:///s//a/b/g");
        URI.testParser(uRI, "./g", "http:///s//a/b/g");
        URI.testParser(uRI, "g/", "http:///s//a/b/g/");
        URI.testParser(uRI, "/g", "http:///g");
        URI.testParser(uRI, "//g", "http://g");
        URI.testParser(uRI, "//g/x", "http://g/x");
        URI.testParser(uRI, "///g", "http:///g");
        URI.testParser(uRI, "./", "http:///s//a/b/");
        URI.testParser(uRI, "../", "http:///s//a/");
        URI.testParser(uRI, "../g", "http:///s//a/g");
        URI.testParser(uRI, "../../", "http:///s//");
        URI.testParser(uRI, "../../g", "http:///s//g");
        URI.testParser(uRI, "../../../g", "http:///s/g");
        URI.testParser(uRI, "../../../../g", "http:///g");
        URI.testNotEqual("http://a/", "nntp://a/");
        URI.testNotEqual("http://a/", "https://a/");
        URI.testNotEqual("http://a/", "shttp://a/");
        URI.testEqual("http://a/", "Http://a/");
        URI.testEqual("http://a/", "hTTP://a/");
        URI.testEqual("url:http://a/", "hTTP://a/");
        URI.testEqual("urI:http://a/", "hTTP://a/");
        URI.testEqual("http://a/", "Http://A/");
        URI.testEqual("http://a.b.c/", "Http://A.b.C/");
        URI.testEqual("http:///", "Http:///");
        URI.testNotEqual("http:///", "Http://a/");
        URI.testEqual("http://a.b.c/", "Http://A.b.C:80/");
        URI.testEqual("http://a.b.c:/", "Http://A.b.C:80/");
        URI.testEqual("nntp://a", "nntp://a:119");
        URI.testEqual("nntp://a:", "nntp://a:119");
        URI.testEqual("nntp://a/", "nntp://a:119/");
        URI.testNotEqual("nntp://a", "nntp://a:118");
        URI.testNotEqual("nntp://a", "nntp://a:0");
        URI.testNotEqual("nntp://a:", "nntp://a:0");
        URI.testEqual("telnet://:23/", "telnet:///");
        URI.testPE(null, "ftp://:a/");
        URI.testPE(null, "ftp://:-1/");
        URI.testPE(null, "ftp://::1/");
        URI.testNotEqual("ftp://me@a", "ftp://a");
        URI.testNotEqual("ftp://me@a", "ftp://Me@a");
        URI.testEqual("ftp://Me@a", "ftp://Me@a");
        URI.testEqual("ftp://Me:My@a:21", "ftp://Me:My@a");
        URI.testEqual("ftp://Me:My@a:", "ftp://Me:My@a");
        URI.testNotEqual("ftp://Me:My@a:21", "ftp://Me:my@a");
        URI.testNotEqual("ftp://Me:My@a:", "ftp://Me:my@a");
        URI.testEqual("ftp://a/b%2b/", "ftp://a/b+/");
        URI.testEqual("ftp://a/b%2b/", "ftp://a/b+/");
        URI.testEqual("ftp://a/b%5E/", "ftp://a/b^/");
        URI.testNotEqual("ftp://a/b%3f/", "ftp://a/b?/");
        System.err.println("*** Tests finished successfuly");
    }

    private void parse_authority(String string, String string2) throws ParseException {
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = cArray.length;
        int n3 = n;
        while (n3 < n2 && cArray[n3] != '@') {
            ++n3;
        }
        if (n3 < n2 && cArray[n3] == '@') {
            this.userinfo = URI.unescape(string.substring(n, n3));
            n = n3 + 1;
        }
        n3 = n;
        while (n3 < n2 && cArray[n3] != ':') {
            ++n3;
        }
        this.host = string.substring(n, n3);
        n = n3;
        if (n < n2 - 1 && cArray[n] == ':') {
            int n4;
            try {
                n4 = Integer.parseInt(string.substring(n + 1, n2));
                if (n4 < 0) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException(String.valueOf(string.substring(n + 1, n2)) + " is an invalid port number");
            }
            this.port = n4 == URI.defaultPort(string2) ? -1 : n4;
        }
    }

    private static void testEqual(String string, String string2) throws Exception {
        if (!new URI(string).equals(new URI(string2))) {
            String string3 = System.getProperty("line.separator");
            throw new Exception("Test failed: " + string3 + "  <" + string + "> != <" + string2 + ">");
        }
    }

    private static void testNotEqual(String string, String string2) throws Exception {
        if (new URI(string).equals(new URI(string2))) {
            String string3 = System.getProperty("line.separator");
            throw new Exception("Test failed: " + string3 + "  <" + string + "> == <" + string2 + ">");
        }
    }

    private static void testPE(URI uRI, String string) throws Exception {
        boolean bl = false;
        try {
            new URI(uRI, string);
        }
        catch (ParseException parseException) {
            bl = true;
        }
        if (!bl) {
            String string2 = System.getProperty("line.separator");
            throw new Exception("Test failed: " + string2 + "  <" + string + "> should be invalid");
        }
    }

    private static void testParser(URI uRI, String string, String string2) throws Exception {
        if (!new URI(uRI, string).toString().equals(string2)) {
            String string3 = System.getProperty("line.separator");
            throw new Exception("Test failed: " + string3 + "  base-URI = <" + uRI + ">" + string3 + "  rel-URI  = <" + string + ">" + string3 + "  expected   <" + string2 + ">" + string3 + "  but got    <" + new URI(uRI, string) + ">");
        }
    }

    public String toExternalForm() {
        StringBuffer stringBuffer = new StringBuffer(100);
        if (this.scheme != null) {
            stringBuffer.append(URI.escape(this.scheme.toCharArray(), schemeChar));
            stringBuffer.append(':');
        }
        if (this.opaque != null) {
            stringBuffer.append(URI.escape(this.opaque.toCharArray(), uricChar));
            return stringBuffer.toString();
        }
        if (this.userinfo != null || this.host != null || this.port != -1) {
            stringBuffer.append("//");
        }
        if (this.userinfo != null) {
            stringBuffer.append(URI.escape(this.userinfo.toCharArray(), userinfoChar));
            stringBuffer.append('@');
        }
        if (this.host != null) {
            stringBuffer.append(this.host.toCharArray());
        }
        if (this.port != -1) {
            stringBuffer.append(':');
            stringBuffer.append(this.port);
        }
        if (this.path != null) {
            stringBuffer.append(this.path.toCharArray());
        }
        if (this.query != null) {
            stringBuffer.append('?');
            stringBuffer.append(URI.escape(this.query.toCharArray(), uricChar));
        }
        if (this.fragment != null) {
            stringBuffer.append('#');
            stringBuffer.append(URI.escape(this.fragment.toCharArray(), uricChar));
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toExternalForm();
    }

    public URL toURL() throws MalformedURLException {
        if (this.url != null) {
            return this.url;
        }
        if (this.opaque != null) {
            this.url = new URL(String.valueOf(this.scheme) + ":" + this.opaque);
            return this.url;
        }
        String string = this.userinfo != null && this.host != null ? String.valueOf(this.userinfo) + "@" + this.host : (this.userinfo != null ? String.valueOf(this.userinfo) + "@" : this.host);
        StringBuffer stringBuffer = new StringBuffer(100);
        if (this.path != null) {
            stringBuffer.append(URI.escape(this.path.toCharArray(), uricChar));
        }
        if (this.query != null) {
            stringBuffer.append('?');
            stringBuffer.append(URI.escape(this.query.toCharArray(), uricChar));
        }
        if (this.fragment != null) {
            stringBuffer.append('#');
            stringBuffer.append(URI.escape(this.fragment.toCharArray(), uricChar));
        }
        this.url = new URL(this.scheme, string, this.port, stringBuffer.toString());
        return this.url;
    }

    static final String unescape(String string) throws ParseException {
        if (string == null || string.indexOf(37) == -1) {
            return string;
        }
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[cArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            if (cArray[n2] == '%') {
                int n3;
                try {
                    n3 = Integer.parseInt(string.substring(n2 + 1, n2 + 3), 16);
                    if (n3 < 0) {
                        throw new NumberFormatException();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParseException(String.valueOf(string.substring(n2, n2 + 3)) + " is an invalid code");
                }
                cArray2[n] = (char)n3;
                n2 += 2;
            } else {
                cArray2[n] = cArray[n2];
            }
            ++n2;
            ++n;
        }
        return new String(cArray2, 0, n);
    }

    private static final String unescapeNoPE(String string) {
        try {
            return URI.unescape(string);
        }
        catch (ParseException parseException) {
            return string;
        }
    }

    public static boolean usesGenericSyntax(String string) {
        return (string = string.trim()).equalsIgnoreCase("http") || string.equalsIgnoreCase("https") || string.equalsIgnoreCase("shttp") || string.equalsIgnoreCase("coffee") || string.equalsIgnoreCase("ftp") || string.equalsIgnoreCase("file") || string.equalsIgnoreCase("gopher") || string.equalsIgnoreCase("nntp") || string.equalsIgnoreCase("smtp") || string.equalsIgnoreCase("telnet") || string.equalsIgnoreCase("news") || string.equalsIgnoreCase("snews") || string.equalsIgnoreCase("hnews") || string.equalsIgnoreCase("rwhois") || string.equalsIgnoreCase("whois++") || string.equalsIgnoreCase("imap") || string.equalsIgnoreCase("pop") || string.equalsIgnoreCase("wais") || string.equalsIgnoreCase("irc") || string.equalsIgnoreCase("nfs") || string.equalsIgnoreCase("ldap") || string.equalsIgnoreCase("prospero") || string.equalsIgnoreCase("z39.50r") || string.equalsIgnoreCase("z39.50s") || string.equalsIgnoreCase("sip") || string.equalsIgnoreCase("sips") || string.equalsIgnoreCase("sipt") || string.equalsIgnoreCase("sipu") || string.equalsIgnoreCase("vemmi") || string.equalsIgnoreCase("videotex");
    }
}

