/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.AuthSchemeNotImplException;
import HTTPClient.AuthorizationHandler;
import HTTPClient.AuthorizationInfo;
import HTTPClient.BasicAuthBox;
import HTTPClient.Codecs;
import HTTPClient.GlobalConstants;
import HTTPClient.HashVerifier;
import HTTPClient.HttpHeaderElement;
import HTTPClient.MD5;
import HTTPClient.MD5InputStream;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.Response;
import HTTPClient.RoRequest;
import HTTPClient.RoResponse;
import HTTPClient.URI;
import HTTPClient.Util;
import HTTPClient.VerifyDigest;
import HTTPClient.VerifyRspAuth;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

class DefaultAuthHandler
implements AuthorizationHandler,
GlobalConstants {
    private static final byte[] NUL = new byte[0];
    private static final int DI_A1 = 0;
    private static final int DI_A1S = 1;
    private static final int DI_QOP = 2;
    private static byte[] digest_secret = null;
    private BasicAuthBox inp = null;

    DefaultAuthHandler() {
    }

    private static String calcResponseAttr(String string, String[] stringArray, NVPair[] nVPairArray, int n, int n2, int n3, int n4, int n5, int n6, String string2) {
        String string3 = n != -1 && nVPairArray[n].getValue().equalsIgnoreCase("MD5-sess") ? stringArray[1] : stringArray[0];
        String string4 = String.valueOf(string2) + ":" + nVPairArray[n2].getValue();
        if (n3 != -1 && nVPairArray[n3].getValue().equalsIgnoreCase("auth-int")) {
            string4 = String.valueOf(string4) + ":" + string;
        }
        string4 = new MD5(string4).asHex();
        String string5 = n3 == -1 ? new MD5(String.valueOf(string3) + ":" + nVPairArray[n4].getValue() + ":" + string4).asHex() : new MD5(String.valueOf(string3) + ":" + nVPairArray[n4].getValue() + ":" + nVPairArray[n5].getValue() + ":" + nVPairArray[n6].getValue() + ":" + nVPairArray[n3].getValue() + ":" + string4).asHex();
        return string5;
    }

    private static String calc_digest(RoRequest roRequest, String string, String string2) {
        Object object;
        if (roRequest.getStream() != null) {
            return "";
        }
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = 0;
        while (n6 < roRequest.getHeaders().length) {
            object = roRequest.getHeaders()[n6].getName();
            if (((String)object).equalsIgnoreCase("Content-type")) {
                n = n6;
            } else if (((String)object).equalsIgnoreCase("Content-Encoding")) {
                n2 = n6;
            } else if (((String)object).equalsIgnoreCase("Last-Modified")) {
                n3 = n6;
            } else if (((String)object).equalsIgnoreCase("Expires")) {
                n4 = n6;
            } else if (((String)object).equalsIgnoreCase("Date")) {
                n5 = n6;
            }
            ++n6;
        }
        object = roRequest.getHeaders();
        byte[] byArray = roRequest.getData() == null ? NUL : roRequest.getData();
        MD5 mD5 = new MD5();
        mD5.Update(byArray);
        String string3 = new MD5(String.valueOf(roRequest.getRequestURI()) + ":" + (n == -1 ? "" : ((NVPair)object[n]).getValue()) + ":" + byArray.length + ":" + (n2 == -1 ? "" : ((NVPair)object[n2]).getValue()) + ":" + (n3 == -1 ? "" : ((NVPair)object[n3]).getValue()) + ":" + (n4 == -1 ? "" : ((NVPair)object[n4]).getValue())).asHex();
        String string4 = String.valueOf(string) + ":" + string2 + ":" + roRequest.getMethod() + ":" + (n5 == -1 ? "" : ((NVPair)object[n5]).getValue()) + ":" + string3 + ":" + mD5.asHex();
        return new MD5(string4).asHex();
    }

    private static AuthorizationInfo digest_check_stale(AuthorizationInfo authorizationInfo, RoRequest roRequest, RoResponse roResponse) throws AuthSchemeNotImplException {
        AuthorizationInfo authorizationInfo2 = null;
        NVPair[] nVPairArray = authorizationInfo.getParams();
        int n = 0;
        while (n < nVPairArray.length) {
            String string = nVPairArray[n].getName();
            if (string.equalsIgnoreCase("stale") && nVPairArray[n].getValue().equalsIgnoreCase("true")) {
                authorizationInfo2 = AuthorizationInfo.getAuthorization(authorizationInfo, roRequest, roResponse, false);
                if (authorizationInfo2 == null) break;
                return DefaultAuthHandler.digest_fixup(authorizationInfo2, roRequest, authorizationInfo, roResponse);
            }
            ++n;
        }
        return authorizationInfo2;
    }

    private static AuthorizationInfo digest_fixup(AuthorizationInfo authorizationInfo, RoRequest roRequest, AuthorizationInfo authorizationInfo2, RoResponse roResponse) throws AuthSchemeNotImplException {
        AuthorizationInfo authorizationInfo3;
        boolean bl;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String[] stringArray;
        NVPair[] nVPairArray;
        int n;
        NVPair[] nVPairArray2;
        int n2;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        NVPair[] nVPairArray3 = null;
        if (authorizationInfo2 != null) {
            nVPairArray3 = authorizationInfo2.getParams();
            n2 = 0;
            while (n2 < nVPairArray3.length) {
                String string = nVPairArray3[n2].getName().toLowerCase();
                if (string.equals("domain")) {
                    n3 = n2;
                } else if (string.equals("nonce")) {
                    n4 = n2;
                } else if (string.equals("opaque")) {
                    n6 = n2;
                } else if (string.equals("algorithm")) {
                    n5 = n2;
                } else if (string.equals("stale")) {
                    n7 = n2;
                } else if (string.equals("digest-required")) {
                    n8 = n2;
                } else if (string.equals("qop")) {
                    n9 = n2;
                }
                ++n2;
            }
        }
        n2 = -1;
        int n10 = -1;
        int n11 = -1;
        int n12 = -1;
        int n13 = -1;
        int n14 = -1;
        int n15 = -1;
        int n16 = -1;
        int n17 = -1;
        int n18 = -1;
        int n19 = -1;
        Object object5 = authorizationInfo;
        synchronized (object5) {
            nVPairArray2 = authorizationInfo.getParams();
            n = 0;
            while (n < nVPairArray2.length) {
                nVPairArray = nVPairArray2[n].getName().toLowerCase();
                if (nVPairArray.equals("uri")) {
                    n2 = n;
                } else if (nVPairArray.equals("username")) {
                    n10 = n;
                } else if (nVPairArray.equals("algorithm")) {
                    n11 = n;
                } else if (nVPairArray.equals("nonce")) {
                    n13 = n;
                } else if (nVPairArray.equals("cnonce")) {
                    n14 = n;
                } else if (nVPairArray.equals("nc")) {
                    n15 = n;
                } else if (nVPairArray.equals("response")) {
                    n12 = n;
                } else if (nVPairArray.equals("opaque")) {
                    n16 = n;
                } else if (nVPairArray.equals("digest")) {
                    n17 = n;
                } else if (nVPairArray.equals("digest-required")) {
                    n18 = n;
                } else if (nVPairArray.equals("qop")) {
                    n19 = n;
                }
                ++n;
            }
            stringArray = (String[])authorizationInfo.getExtraInfo();
            if (n11 != -1 && !nVPairArray2[n11].getValue().equalsIgnoreCase("MD5") && !nVPairArray2[n11].getValue().equalsIgnoreCase("MD5-sess")) {
                throw new AuthSchemeNotImplException("Digest auth scheme: Algorithm " + nVPairArray2[n11].getValue() + " not implemented");
            }
            if (n5 != -1 && !nVPairArray3[n5].getValue().equalsIgnoreCase("MD5") && !nVPairArray3[n5].getValue().equalsIgnoreCase("MD5-sess")) {
                throw new AuthSchemeNotImplException("Digest auth scheme: Algorithm " + nVPairArray3[n5].getValue() + " not implemented");
            }
            nVPairArray2[n2] = new NVPair("uri", roRequest.getRequestURI());
            nVPairArray = nVPairArray2[n13].getValue();
            if (n4 != -1 && !nVPairArray.equals(nVPairArray3[n4].getValue())) {
                nVPairArray2[n13] = nVPairArray3[n4];
            }
            if (n6 != -1) {
                if (n16 == -1) {
                    nVPairArray2 = Util.resizeArray(nVPairArray2, nVPairArray2.length + 1);
                    n16 = nVPairArray2.length - 1;
                }
                nVPairArray2[n16] = nVPairArray3[n6];
            }
            if (n5 != -1) {
                if (n11 == -1) {
                    nVPairArray2 = Util.resizeArray(nVPairArray2, nVPairArray2.length + 1);
                    n11 = nVPairArray2.length - 1;
                }
                nVPairArray2[n11] = nVPairArray3[n5];
            }
            if (n9 != -1 || n5 != -1 && nVPairArray3[n5].getValue().equalsIgnoreCase("MD5-sess")) {
                if (n14 == -1) {
                    nVPairArray2 = Util.resizeArray(nVPairArray2, nVPairArray2.length + 1);
                    n14 = nVPairArray2.length - 1;
                }
                if (digest_secret == null) {
                    digest_secret = DefaultAuthHandler.gen_random_bytes(20);
                }
                long l = System.currentTimeMillis();
                object4 = new byte[]{(byte)(l & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 24 & 0xFFL), (byte)(l >> 32 & 0xFFL), (byte)(l >> 40 & 0xFFL), (byte)(l >> 48 & 0xFFL), (byte)(l >> 56 & 0xFFL)};
                object3 = new MD5(digest_secret);
                ((MD5)object3).Update((byte[])object4);
                nVPairArray2[n14] = new NVPair("cnonce", ((MD5)object3).asHex());
            }
            if (n9 != -1) {
                if (n19 == -1) {
                    nVPairArray2 = Util.resizeArray(nVPairArray2, nVPairArray2.length + 1);
                    n19 = nVPairArray2.length - 1;
                }
                stringArray[2] = nVPairArray3[n9].getValue();
                String[] stringArray2 = DefaultAuthHandler.splitList(stringArray[2], ",");
                object2 = null;
                int n20 = 0;
                while (n20 < stringArray2.length) {
                    if (stringArray2[n20].equalsIgnoreCase("auth-int") && (roRequest.getStream() == null || roRequest.getConnection().ServProtVersKnown && roRequest.getConnection().ServerProtocolVersion >= 65537)) {
                        object2 = "auth-int";
                        break;
                    }
                    if (stringArray2[n20].equalsIgnoreCase("auth")) {
                        object2 = "auth";
                    }
                    ++n20;
                }
                if (object2 == null) {
                    int n21 = 0;
                    while (n21 < stringArray2.length) {
                        if (stringArray2[n21].equalsIgnoreCase("auth-int")) {
                            throw new AuthSchemeNotImplException("Digest auth scheme: Can't comply with qop option 'auth-int' because an HttpOutputStream is being used and the server doesn't speak HTTP/1.1");
                        }
                        ++n21;
                    }
                    throw new AuthSchemeNotImplException("Digest auth scheme: None of the available qop options '" + nVPairArray3[n9].getValue() + "' implemented");
                }
                nVPairArray2[n19] = new NVPair("qop", (String)object2);
            }
            if (n19 != -1) {
                if (n15 == -1) {
                    nVPairArray2 = Util.resizeArray(nVPairArray2, nVPairArray2.length + 1);
                    n15 = nVPairArray2.length - 1;
                    nVPairArray2[n15] = new NVPair("nc", "00000001");
                } else if (nVPairArray.equals(nVPairArray2[n13].getValue())) {
                    String string = Long.toHexString(Long.parseLong(nVPairArray2[n15].getValue(), 16) + 1L);
                    nVPairArray2[n15] = new NVPair("nc", String.valueOf("00000000".substring(string.length())) + string);
                } else {
                    nVPairArray2[n15] = new NVPair("nc", "00000001");
                }
            }
            if (authorizationInfo2 != null && (n7 == -1 || !nVPairArray3[n7].getValue().equalsIgnoreCase("true")) && n11 != -1 && nVPairArray2[n11].getValue().equalsIgnoreCase("MD5-sess")) {
                stringArray[1] = new MD5(String.valueOf(stringArray[0]) + ":" + nVPairArray2[n13].getValue() + ":" + nVPairArray2[n14].getValue()).asHex();
            }
            authorizationInfo.setParams(nVPairArray2);
            authorizationInfo.setExtraInfo(stringArray);
        }
        object5 = null;
        if (n19 != -1 && nVPairArray2[n19].getValue().equalsIgnoreCase("auth-int") && roRequest.getStream() == null) {
            object = new MD5();
            ((MD5)object).Update(roRequest.getData() == null ? NUL : roRequest.getData());
            object5 = ((MD5)object).asHex();
        }
        if (roRequest.getStream() == null) {
            nVPairArray2[n12] = new NVPair("response", DefaultAuthHandler.calcResponseAttr((String)object5, stringArray, nVPairArray2, n11, n2, n19, n13, n15, n14, roRequest.getMethod()));
        }
        n = 0;
        if (n8 != -1 && (nVPairArray3[n8].getValue() == null || nVPairArray3[n8].getValue().equalsIgnoreCase("true"))) {
            n = 1;
        }
        if ((n != 0 || n17 != -1) && roRequest.getStream() == null) {
            if (n17 == -1) {
                nVPairArray = Util.resizeArray(nVPairArray2, nVPairArray2.length + 1);
                n17 = nVPairArray2.length;
            } else {
                nVPairArray = nVPairArray2;
            }
            nVPairArray[n17] = new NVPair("digest", DefaultAuthHandler.calc_digest(roRequest, stringArray[0], nVPairArray2[n13].getValue()));
            if (n18 == -1) {
                n18 = nVPairArray.length;
                nVPairArray = Util.resizeArray(nVPairArray, nVPairArray.length + 1);
                nVPairArray[n18] = new NVPair("digest-required", "true");
            }
            object = new AuthorizationInfo(authorizationInfo.getHost(), authorizationInfo.getPort(), authorizationInfo.getScheme(), authorizationInfo.getRealm(), nVPairArray, stringArray);
        } else {
            object = n != 0 ? null : new AuthorizationInfo(authorizationInfo.getHost(), authorizationInfo.getPort(), authorizationInfo.getScheme(), authorizationInfo.getRealm(), nVPairArray2, stringArray);
        }
        boolean bl2 = bl = authorizationInfo2 != null && authorizationInfo2.getHost().equalsIgnoreCase(roRequest.getConnection().getHost());
        if (n3 != -1) {
            URI uRI = null;
            try {
                uRI = new URI(roRequest.getConnection().getProtocol(), roRequest.getConnection().getHost(), roRequest.getConnection().getPort(), roRequest.getRequestURI());
            }
            catch (ParseException parseException) {}
            object2 = new StringTokenizer(nVPairArray3[n3].getValue());
            while (((StringTokenizer)object2).hasMoreTokens()) {
                try {
                    object4 = new URI(uRI, ((StringTokenizer)object2).nextToken());
                }
                catch (ParseException parseException) {
                    continue;
                }
                object3 = AuthorizationInfo.getAuthorization(object4.getHost(), object4.getPort(), authorizationInfo.getScheme(), authorizationInfo.getRealm(), roRequest.getConnection().getContext());
                if (object3 == null) {
                    nVPairArray2[n2] = new NVPair("uri", object4.getPath());
                    object3 = new AuthorizationInfo(object4.getHost(), object4.getPort(), authorizationInfo.getScheme(), authorizationInfo.getRealm(), nVPairArray2, stringArray);
                    AuthorizationInfo.addAuthorization((AuthorizationInfo)object3);
                }
                if (!bl) continue;
                ((AuthorizationInfo)object3).addPath(object4.getPath());
            }
        } else if (bl && authorizationInfo2 != null && (authorizationInfo3 = AuthorizationInfo.getAuthorization(authorizationInfo2.getHost(), authorizationInfo2.getPort(), authorizationInfo.getScheme(), authorizationInfo.getRealm(), roRequest.getConnection().getContext())) != null) {
            authorizationInfo3.addPath("/");
        }
        return object;
    }

    private static AuthorizationInfo digest_gen_auth_info(String string, int n, String string2, String string3, String string4, Object object) {
        NVPair[] nVPairArray;
        String string5 = String.valueOf(string3) + ":" + string2 + ":" + string4;
        String[] stringArray = new String[]{new MD5(string5).asHex(), null, null};
        AuthorizationInfo authorizationInfo = AuthorizationInfo.getAuthorization(string, n, "Digest", string2, object);
        if (authorizationInfo == null) {
            nVPairArray = new NVPair[]{new NVPair("username", string3), new NVPair("uri", ""), new NVPair("nonce", ""), new NVPair("response", "")};
        } else {
            nVPairArray = authorizationInfo.getParams();
            int n2 = 0;
            while (n2 < nVPairArray.length) {
                if (nVPairArray[n2].getName().equalsIgnoreCase("username")) {
                    nVPairArray[n2] = new NVPair("username", string3);
                    break;
                }
                ++n2;
            }
        }
        return new AuthorizationInfo(string, n, "Digest", string2, nVPairArray, stringArray);
    }

    public AuthorizationInfo fixupAuthInfo(AuthorizationInfo authorizationInfo, RoRequest roRequest, AuthorizationInfo authorizationInfo2, RoResponse roResponse) throws AuthSchemeNotImplException {
        if (authorizationInfo.getScheme().equalsIgnoreCase("Basic") || authorizationInfo.getScheme().equalsIgnoreCase("SOCKS5")) {
            return authorizationInfo;
        }
        if (!authorizationInfo.getScheme().equalsIgnoreCase("Digest")) {
            throw new AuthSchemeNotImplException(authorizationInfo.getScheme());
        }
        return DefaultAuthHandler.digest_fixup(authorizationInfo, roRequest, authorizationInfo2, roResponse);
    }

    private static byte[] gen_random_bytes(int n) {
        try {
            FileInputStream fileInputStream = new FileInputStream("/dev/random");
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            byte[] byArray = new byte[n];
            dataInputStream.readFully(byArray);
            try {
                dataInputStream.close();
            }
            catch (IOException iOException) {}
            return byArray;
        }
        catch (Throwable throwable) {
            byte[] byArray = new byte[n];
            try {
                long l = Runtime.getRuntime().freeMemory();
                byArray[0] = (byte)(l & 0xFFL);
                byArray[1] = (byte)(l >> 8 & 0xFFL);
                int n2 = byArray.hashCode();
                byArray[2] = (byte)(n2 & 0xFF);
                byArray[3] = (byte)(n2 >> 8 & 0xFF);
                byArray[4] = (byte)(n2 >> 16 & 0xFF);
                byArray[5] = (byte)(n2 >> 24 & 0xFF);
                long l2 = System.currentTimeMillis();
                byArray[6] = (byte)(l2 & 0xFFL);
                byArray[7] = (byte)(l2 >> 8 & 0xFFL);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
            return byArray;
        }
    }

    public AuthorizationInfo getAuthorization(AuthorizationInfo authorizationInfo, RoRequest roRequest, RoResponse roResponse) throws AuthSchemeNotImplException {
        Object object;
        AuthorizationInfo authorizationInfo2;
        if (!(authorizationInfo.getScheme().equalsIgnoreCase("Basic") || authorizationInfo.getScheme().equalsIgnoreCase("Digest") || authorizationInfo.getScheme().equalsIgnoreCase("SOCKS5"))) {
            throw new AuthSchemeNotImplException(authorizationInfo.getScheme());
        }
        if (authorizationInfo.getScheme().equalsIgnoreCase("Digest") && (authorizationInfo2 = DefaultAuthHandler.digest_check_stale(authorizationInfo, roRequest, roResponse)) != null) {
            return authorizationInfo2;
        }
        if (!roRequest.allowUI()) {
            return null;
        }
        if (this.inp == null) {
            object = this.getClass();
            synchronized (object) {
                if (this.inp == null) {
                    this.inp = new BasicAuthBox();
                }
            }
        }
        if ((object = authorizationInfo.getScheme().equalsIgnoreCase("basic") || authorizationInfo.getScheme().equalsIgnoreCase("Digest") ? this.inp.getInput("Enter username and password for realm `" + authorizationInfo.getRealm() + "'", "on host " + authorizationInfo.getHost() + ":" + authorizationInfo.getPort(), "Authentication Scheme: " + authorizationInfo.getScheme()) : this.inp.getInput("Enter username and password for SOCKS server on host ", authorizationInfo.getHost(), "Authentication Method: username/password")) == null) {
            return null;
        }
        if (authorizationInfo.getScheme().equalsIgnoreCase("basic")) {
            authorizationInfo2 = new AuthorizationInfo(authorizationInfo.getHost(), authorizationInfo.getPort(), authorizationInfo.getScheme(), authorizationInfo.getRealm(), Codecs.base64Encode(String.valueOf(((NVPair)object).getName()) + ":" + ((NVPair)object).getValue()));
        } else if (authorizationInfo.getScheme().equalsIgnoreCase("Digest")) {
            authorizationInfo2 = DefaultAuthHandler.digest_gen_auth_info(authorizationInfo.getHost(), authorizationInfo.getPort(), authorizationInfo.getRealm(), ((NVPair)object).getName(), ((NVPair)object).getValue(), roRequest.getConnection().getContext());
            authorizationInfo2 = DefaultAuthHandler.digest_fixup(authorizationInfo2, roRequest, authorizationInfo, null);
        } else {
            NVPair[] nVPairArray = new NVPair[]{object};
            authorizationInfo2 = new AuthorizationInfo(authorizationInfo.getHost(), authorizationInfo.getPort(), authorizationInfo.getScheme(), authorizationInfo.getRealm(), nVPairArray, null);
        }
        object = null;
        System.gc();
        return authorizationInfo2;
    }

    private static final int getIndex(NVPair[] nVPairArray, String string) {
        int n = nVPairArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (nVPairArray[n2].getName().equalsIgnoreCase(string)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private static final String getValue(NVPair[] nVPairArray, String string) {
        int n = nVPairArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (nVPairArray[n2].getName().equalsIgnoreCase(string)) {
                return nVPairArray[n2].getValue();
            }
            ++n2;
        }
        return null;
    }

    public void handleAuthHeaders(Response response, RoRequest roRequest, AuthorizationInfo authorizationInfo, AuthorizationInfo authorizationInfo2) throws IOException {
        String string = response.getHeader("Authentication-Info");
        String string2 = response.getHeader("Proxy-Authentication-Info");
        if (string == null && authorizationInfo != null && DefaultAuthHandler.hasParam(authorizationInfo.getParams(), "qop", "auth-int")) {
            string = "";
        }
        if (string2 == null && authorizationInfo2 != null && DefaultAuthHandler.hasParam(authorizationInfo2.getParams(), "qop", "auth-int")) {
            string2 = "";
        }
        try {
            DefaultAuthHandler.handleAuthInfo(string, "Authentication-Info", authorizationInfo, response, roRequest, true);
            DefaultAuthHandler.handleAuthInfo(string2, "Proxy-Authentication-Info", authorizationInfo2, response, roRequest, true);
        }
        catch (ParseException parseException) {
            throw new IOException(parseException.toString());
        }
    }

    private static void handleAuthInfo(String string, String string2, AuthorizationInfo authorizationInfo, Response response, RoRequest roRequest, boolean bl) throws ParseException, IOException {
        if (string == null) {
            return;
        }
        Vector vector = Util.parseHeader(string);
        HttpHeaderElement httpHeaderElement = Util.getElement(vector, "nextnonce");
        if (DefaultAuthHandler.handle_nextnonce(authorizationInfo, roRequest, httpHeaderElement)) {
            vector.removeElement(httpHeaderElement);
        }
        if (DefaultAuthHandler.handle_discard(authorizationInfo, roRequest, httpHeaderElement = Util.getElement(vector, "discard"))) {
            vector.removeElement(httpHeaderElement);
        }
        if (bl) {
            HttpHeaderElement httpHeaderElement2 = null;
            if (vector != null && (httpHeaderElement2 = Util.getElement(vector, "qop")) != null && httpHeaderElement2.getValue() != null) {
                DefaultAuthHandler.handle_rspauth(authorizationInfo, response, roRequest, vector, string2);
            } else if (authorizationInfo != null && (Util.hasToken(response.getHeader("Trailer"), string2) && DefaultAuthHandler.hasParam(authorizationInfo.getParams(), "qop", null) || DefaultAuthHandler.hasParam(authorizationInfo.getParams(), "qop", "auth-int"))) {
                DefaultAuthHandler.handle_rspauth(authorizationInfo, response, roRequest, null, string2);
            } else if (vector != null && httpHeaderElement2 == null && vector.contains(new HttpHeaderElement("digest")) || Util.hasToken(response.getHeader("Trailer"), string2) && authorizationInfo != null && !DefaultAuthHandler.hasParam(authorizationInfo.getParams(), "qop", null)) {
                DefaultAuthHandler.handle_digest(authorizationInfo, response, roRequest, string2);
            }
        }
        if (vector.size() > 0) {
            response.setHeader(string2, Util.assembleHeader(vector));
        } else {
            response.deleteHeader(string2);
        }
    }

    public void handleAuthTrailers(Response response, RoRequest roRequest, AuthorizationInfo authorizationInfo, AuthorizationInfo authorizationInfo2) throws IOException {
        String string = response.getTrailer("Authentication-Info");
        String string2 = response.getTrailer("Proxy-Authentication-Info");
        try {
            DefaultAuthHandler.handleAuthInfo(string, "Authentication-Info", authorizationInfo, response, roRequest, false);
            DefaultAuthHandler.handleAuthInfo(string2, "Proxy-Authentication-Info", authorizationInfo2, response, roRequest, false);
        }
        catch (ParseException parseException) {
            throw new IOException(parseException.toString());
        }
    }

    private static boolean handle_digest(AuthorizationInfo authorizationInfo, Response response, RoRequest roRequest, String string) throws IOException {
        if (authorizationInfo == null) {
            return false;
        }
        NVPair[] nVPairArray = authorizationInfo.getParams();
        VerifyDigest verifyDigest = new VerifyDigest(((String[])authorizationInfo.getExtraInfo())[0], DefaultAuthHandler.getValue(nVPairArray, "nonce"), roRequest.getMethod(), DefaultAuthHandler.getValue(nVPairArray, "uri"), string, response);
        if (response.hasEntity()) {
            response.inp_stream = new MD5InputStream(response.inp_stream, verifyDigest);
        } else {
            verifyDigest.verifyHash(new MD5().Final(), 0L);
        }
        return true;
    }

    private static boolean handle_discard(AuthorizationInfo authorizationInfo, RoRequest roRequest, HttpHeaderElement httpHeaderElement) {
        if (httpHeaderElement != null && authorizationInfo != null) {
            AuthorizationInfo.removeAuthorization(authorizationInfo, roRequest.getConnection().getContext());
            return true;
        }
        return false;
    }

    private static boolean handle_nextnonce(AuthorizationInfo authorizationInfo, RoRequest roRequest, HttpHeaderElement httpHeaderElement) {
        AuthorizationInfo authorizationInfo2;
        if (authorizationInfo == null || httpHeaderElement == null || httpHeaderElement.getValue() == null) {
            return false;
        }
        try {
            authorizationInfo2 = AuthorizationInfo.getAuthorization(authorizationInfo, roRequest, null, false);
        }
        catch (AuthSchemeNotImplException authSchemeNotImplException) {
            authorizationInfo2 = authorizationInfo;
        }
        AuthorizationInfo authorizationInfo3 = authorizationInfo2;
        synchronized (authorizationInfo3) {
            NVPair[] nVPairArray = authorizationInfo2.getParams();
            nVPairArray = DefaultAuthHandler.setValue(nVPairArray, "nonce", httpHeaderElement.getValue());
            nVPairArray = DefaultAuthHandler.setValue(nVPairArray, "nc", "00000000");
            authorizationInfo2.setParams(nVPairArray);
        }
        return true;
    }

    private static boolean handle_rspauth(AuthorizationInfo authorizationInfo, Response response, RoRequest roRequest, Vector vector, String string) throws IOException {
        Object object;
        if (authorizationInfo == null) {
            return false;
        }
        NVPair[] nVPairArray = authorizationInfo.getParams();
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = 0;
        while (n6 < nVPairArray.length) {
            object = nVPairArray[n6].getName().toLowerCase();
            if (((String)object).equals("uri")) {
                n = n6;
            } else if (((String)object).equals("algorithm")) {
                n2 = n6;
            } else if (((String)object).equals("nonce")) {
                n3 = n6;
            } else if (((String)object).equals("cnonce")) {
                n4 = n6;
            } else if (((String)object).equals("nc")) {
                n5 = n6;
            }
            ++n6;
        }
        object = new VerifyRspAuth(nVPairArray[n].getValue(), ((String[])authorizationInfo.getExtraInfo())[0], n2 == -1 ? null : nVPairArray[n2].getValue(), nVPairArray[n3].getValue(), n4 == -1 ? "" : nVPairArray[n4].getValue(), n5 == -1 ? "" : nVPairArray[n5].getValue(), string, response);
        HttpHeaderElement httpHeaderElement = null;
        if (vector != null && (httpHeaderElement = Util.getElement(vector, "qop")) != null && httpHeaderElement.getValue() != null && (httpHeaderElement.getValue().equalsIgnoreCase("auth") || !response.hasEntity() && httpHeaderElement.getValue().equalsIgnoreCase("auth-int"))) {
            ((VerifyRspAuth)object).verifyHash(new MD5().Final(), 0L);
        } else {
            response.inp_stream = new MD5InputStream(response.inp_stream, (HashVerifier)object);
        }
        return true;
    }

    private static final boolean hasParam(NVPair[] nVPairArray, String string, String string2) {
        int n = 0;
        while (n < nVPairArray.length) {
            if (nVPairArray[n].getName().equalsIgnoreCase(string) && (string2 == null || nVPairArray[n].getValue().equalsIgnoreCase(string2))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    static String hex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 3);
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(Character.forDigit(byArray[n] >>> 4, 16));
            stringBuffer.append(Character.forDigit(byArray[n] & 0x10, 16));
            stringBuffer.append(':');
            ++n;
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    private static final NVPair[] setValue(NVPair[] nVPairArray, String string, String string2) {
        int n = DefaultAuthHandler.getIndex(nVPairArray, string);
        if (n == -1) {
            n = nVPairArray.length;
            nVPairArray = Util.resizeArray(nVPairArray, nVPairArray.length + 1);
        }
        nVPairArray[n] = new NVPair(string, string2);
        return nVPairArray;
    }

    private static String[] splitList(String string, String string2) {
        if (string == null) {
            return new String[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = stringTokenizer.nextToken().trim();
            ++n;
        }
        return stringArray;
    }

    static final byte[] unHex(String string) {
        byte[] byArray = new byte[string.length() / 2];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = (byte)(0xFF & Integer.parseInt(string.substring(2 * n, 2 * (n + 1)), 16));
            ++n;
        }
        return byArray;
    }
}

