/*
 * Decompiled with CFR 0.152.
 */
package jacorb.orb.domain.gui;

import jacorb.orb.domain.Domain;
import jacorb.orb.domain.Util;
import jacorb.orb.domain.gui.MemberListLeafNode;
import jacorb.util.Debug;
import javax.swing.tree.DefaultMutableTreeNode;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.Object;

public class MemberListRootNode
extends DefaultMutableTreeNode {
    private Domain theDomain;
    private String[] theValidNames;

    public MemberListRootNode(Domain domain) {
        super(domain.name());
        this.theDomain = domain;
        Debug.assert(2, domain != null, "domain is null");
        Object[] objectArray = domain.getMembers();
        this.theValidNames = new String[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            try {
                this.theValidNames[n] = domain.getNameOf(objectArray[n]);
                if (this.theValidNames[n] == null || this.theValidNames[n].equals("")) {
                    this.theValidNames[n] = "???";
                }
            }
            catch (COMM_FAILURE cOMM_FAILURE) {
                Debug.output(32770, " MemberListRootNode.init: comm failure at call of <" + domain.name() + ">.getNameOf()");
                this.theValidNames[n] = "???";
            }
            ++n;
        }
        Util.quicksort(0, objectArray.length - 1, this.theValidNames);
        int n2 = 0;
        while (n2 < objectArray.length) {
            Object object = this.theDomain.resolveName(this.theValidNames[n2]);
            if (object == null) {
                Debug.output(32772, "name " + this.theValidNames[n2] + "not valid");
            } else {
                this.add(new MemberListLeafNode(object, this.theDomain, this.theValidNames[n2]));
            }
            ++n2;
        }
    }

    public Domain getDomain() {
        Debug.assert(1, this.theDomain != null, " domain representing tree node is null ");
        return this.theDomain;
    }

    public boolean isLeaf() {
        return false;
    }
}

