/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.Util;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

final class ExtBufferedInputStream
extends FilterInputStream {
    protected byte[] buf;
    protected int count;
    protected int pos;
    protected int markpos = -1;
    protected int marklimit;

    public ExtBufferedInputStream(InputStream inputStream) {
        this(inputStream, 2048);
    }

    public ExtBufferedInputStream(InputStream inputStream, int n) {
        super(inputStream);
        this.buf = new byte[n];
    }

    public synchronized int available() throws IOException {
        return this.count - this.pos + this.in.available();
    }

    private void fill() throws IOException {
        int n;
        if (this.markpos < 0) {
            this.pos = 0;
        } else if (this.pos >= this.buf.length) {
            if (this.markpos > 0) {
                n = this.pos - this.markpos;
                System.arraycopy(this.buf, this.markpos, this.buf, 0, n);
                this.pos = n;
                this.markpos = 0;
            } else if (this.buf.length >= this.marklimit) {
                this.markpos = -1;
                this.pos = 0;
            } else {
                n = this.pos * 2;
                if (n > this.marklimit) {
                    n = this.marklimit;
                }
                byte[] byArray = new byte[n];
                System.arraycopy(this.buf, 0, byArray, 0, this.pos);
                this.buf = byArray;
            }
        }
        this.count = this.pos;
        n = this.in.read(this.buf, this.pos, this.buf.length - this.pos);
        this.count = n <= 0 ? this.pos : n + this.pos;
    }

    void initMark() {
        this.mark(this.buf.length);
    }

    public synchronized void mark(int n) {
        this.marklimit = n;
        this.markpos = this.pos;
    }

    public boolean markSupported() {
        return true;
    }

    int pastEnd(byte[] byArray, int[] nArray) {
        int n = Util.findStr(byArray, nArray, this.buf, this.markpos, this.pos);
        if (n == -1) {
            this.markpos = this.pos - byArray.length;
        } else {
            this.markpos = n + byArray.length;
            n = this.pos - this.markpos;
        }
        return n;
    }

    public synchronized int read() throws IOException {
        if (this.pos >= this.count) {
            this.fill();
            if (this.pos >= this.count) {
                return -1;
            }
        }
        return this.buf[this.pos++] & 0xFF;
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.count - this.pos;
        if (n3 <= 0) {
            if (n2 >= this.buf.length && this.markpos < 0) {
                return this.in.read(byArray, n, n2);
            }
            this.fill();
            n3 = this.count - this.pos;
            if (n3 <= 0) {
                return -1;
            }
        }
        int n4 = n3 < n2 ? n3 : n2;
        System.arraycopy(this.buf, this.pos, byArray, n, n4);
        this.pos += n4;
        return n4;
    }

    public synchronized void reset() throws IOException {
        if (this.markpos < 0) {
            throw new IOException("Resetting to invalid mark");
        }
        this.pos = this.markpos;
    }

    public synchronized long skip(long l) throws IOException {
        if (l < 0L) {
            return 0L;
        }
        long l2 = this.count - this.pos;
        if (l2 >= l) {
            this.pos = (int)((long)this.pos + l);
            return l;
        }
        this.pos = (int)((long)this.pos + l2);
        return l2 + this.in.skip(l - l2);
    }
}

