/*
 * Decompiled with CFR 0.152.
 */
package jacorb.idl;

import jacorb.idl.BaseType;
import jacorb.idl.IdlSymbol;
import jacorb.idl.SwitchTypeSpec;
import jacorb.idl.TypeSpec;

class CharType
extends BaseType
implements SwitchTypeSpec {
    private boolean wide = false;

    public CharType(int n) {
        super(n);
    }

    public boolean basic() {
        return true;
    }

    public Object clone() {
        CharType charType = new CharType(IdlSymbol.new_num());
        if (this.wide) {
            charType.setWide();
        }
        return charType;
    }

    public int getTCKind() {
        if (this.wide) {
            return 26;
        }
        return 9;
    }

    public String holderName() {
        return "org.omg.CORBA.CharHolder";
    }

    public boolean isWide() {
        return this.wide;
    }

    public String printExtractExpression() {
        if (this.wide) {
            return "extract_wchar";
        }
        return "extract_char";
    }

    public String printInsertExpression() {
        if (this.wide) {
            return "insert_wchar";
        }
        return "insert_char";
    }

    public String printReadExpression(String string) {
        if (this.wide) {
            return String.valueOf(string) + ".read_wchar()";
        }
        return String.valueOf(string) + ".read_char()";
    }

    public String printWriteStatement(String string, String string2) {
        if (this.wide) {
            return String.valueOf(string2) + ".write_wchar(" + string + ");";
        }
        return String.valueOf(string2) + ".write_char(" + string + ");";
    }

    public void setWide() {
        this.wide = true;
    }

    public String signature() {
        return "C";
    }

    public String toString() {
        return this.typeName();
    }

    public String typeName() {
        return "char";
    }

    public TypeSpec typeSpec() {
        return this;
    }
}

