package jacorb.orb.domain;
/**
 * DomainFactoryImpl.java
 *
 *
 * Created: Mon Mar  6 10:29:25 2000
 *
 * @author Herbert Kiefer
 * @version $Revision: 1.1 $
 */

public class DomainFactoryImpl extends DomainFactoryPOA
{
  public DomainFactoryImpl() 
  {}

  /** creates a domain  object. 
   *  Post: result is a domain  AND result.isRoot() */
  public Domain createDomain
    (org.omg.CORBA.Object[] initialMembers,
     org.omg.CORBA.Policy[] initialPolicies,
     int                    defaultPolicyType,
     String                 description)
  {
    DomainImpl domain= new DomainImpl(initialMembers,
				      initialPolicies,
				      defaultPolicyType,
				      description);

    Domain result= null;
    try 
      {
	result = DomainHelper.narrow(_poa().servant_to_reference(domain));
      } 
    catch (org.omg.PortableServer.POAPackage.WrongPolicy wp) 
	{
	  jacorb.util.Debug.output(1, "the poa of this domain(" + this 
	         +") has the wrong policies for \"servant_to_reference\".");
	}
    catch (Exception e)
      {
	jacorb.util.Debug.output(1, e);
      } 
      
    jacorb.util.Debug.output(4, "Domain.createDomain: finished.");

    jacorb.util.Debug.assert(2, result != null, "DomainFactoryImpl.createDomain: result is null");
    jacorb.util.Debug.assert(2, result.isRoot(),"DomainFactoryImpl.createDomain: result is"
			     +"not a root domain");

    return result;
  }

  
} // DomainFactoryImpl
