package jacorb.orb;

/*
 *        JacORB - a free Java ORB
 *
 *   Copyright (C) 1997-2000  Gerald Brose.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/**
 * Interface for connections on the clide side
 * 
 * @author Gerald Brose, FU Berlin
 * @version $Id: ClientSideConnection.java,v 1.2 2000/03/17 09:01:35 brose Exp $
 *
 */

import java.io.*;
import java.net.*;
import java.util.*;
import jacorb.orb.giop.*;
import jacorb.util.*;

public interface ClientSideConnection 
{
    public Hashtable get_buffers();

    public Hashtable get_objects();
    
    public Hashtable get_replies();

    public void  receiveReply()  
	throws IOException, CloseConnectionException;

    public LocateReplyInputStream sendLocateRequest( LocateRequestOutputStream os ) 
	throws org.omg.CORBA.COMM_FAILURE;

    /** writes the arguments of method calls to the output stream */	
    public org.omg.CORBA.portable.InputStream sendRequest( org.omg.CORBA.Object o,
							   RequestOutputStream os ) 
	throws org.omg.CORBA.COMM_FAILURE;

    void writeDirectly(byte[] buffer,int len) 
	throws IOException;
}
