package jacorb.util.net;

/*
 *        Written for JacORB - a free Java ORB
 *
 *   Copyright (C) 1999  Andr Benvenuti.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* We follow the design of socket factories in jsse (package javax.net and javax.net.ssl).
 * Because this package don't the JDK yet, and not exported in Europe, we don't extend its classes.
 * But we remain compatible, and could actualy use the jsse instead.
 *
 * The basic idea is to setup policies related to the sockets being constructed,
 * in the factory: no special configuration is done in the code which asks for the sockets.
 * 
 * We will use the polymorphism of both factories and sockets, to enable poeple 
 * to use different SSL implementations. The ORB will get different kinds of factories. 
 * The Factories will customize the special parameters used in socket construction.
 * But the sockets returned to the application have to be subclasses of java.net.Socket,
 * Which factory classes is used will be decide in jacorb.util.Environment as this is specific
 * to the environment configuration.
 * So the getDefault method could return null if no SSL support at all, or a factory that encapsulates
 * a particular implementation and take care of initialising and pass specific parameters. 
 */

public abstract class SocketFactory {
	public SocketFactory() {}
	public abstract java.net.Socket createSocket ( java.lang.String host,
                	                               int port
                	                             )
                      	                throws java.io.IOException,
                      	                       java.net.UnknownHostException;
	/* Returns a socket connected to a ServerSocket on the named host, at the given port.
	 * This socket is configured using the socket options established for this factory.
	 * Parameters:
	 * 	host - the server host
	 * 	port - the server port
	 * Throws:
	 * 	java.io.IOException - if the connection can't be established
	 * 	java.net.UnknownHostException - if the host is not known
	 */
	public abstract java.net.Socket createSocket ( java.lang.String host,
	                                               int port,
	                                               java.net.InetAddress clientHost,
	                                               int clientPort
	                                             )
	                                      throws java.io.IOException,
	                                             java.net.UnknownHostException;
	/* Returns a socket connected to a ServerSocket on the named host, at the given port.
	 * The client address address is the specified host and port. This socket is configured using the socket options established for this factory.
	 * Parameters:
	 * 	host - the server host
	 * 	port - the server port
	 * 	clientHost - the client host
	 * 	clientPort - the client port
	 * Throws:
	 * 	java.io.IOException - if the connection can't be established
	 * 	java.net.UnknownHostException - if the host is not known
	 */
	public abstract java.net.Socket createSocket(java.net.InetAddress host,
	                                             int port)
	                                      throws java.io.IOException;
	/*Returns a socket connected to a ServerSocket at the specified network address and port. This socket is configured using the socket options established for this factory.
	 * Parameters:
	 * 	host - the server host
	 * 	port - the server port
	 * Throws:
	 * 	java.io.IOException - if the connection can't be established
	 */
	public abstract java.net.Socket createSocket(java.net.InetAddress address,
	                                             int port,
	                                             java.net.InetAddress clientAddress,
	                                             int clientPort)
	                                      throws java.io.IOException;
	/* Returns a socket connected to a ServerSocket at the specified network address and port. The client is bound to the specified network address and port, and the socket is configured using the socket options established for this factory.
	 * Parameters:
	 * 	address - the server network address
	 * 	port - the server port
	 * 	clientAddress - the client network address
	 * 	clientPort - the client port
	 * Throws:
	 * 	java.io.IOException - if the connection can't be established
	 */
	public static SocketFactory getDefault()
	/* Returns the default SSL socket factory.
	 * If SSL has not been configured for this virtual machine,
	 * the factory will be inoperative (reporting instantiation exceptions).
	 */
	{
		return null;
	}
}