
// Copyright (C) 1998-1999
// Object Oriented Concepts, Inc.

// **********************************************************************
//
// Copyright (c) 1997
// Mark Spruiell (mark@intellisoft.com)
//
// See the COPYING file for more information
//
// **********************************************************************

package jacorb.trading.client.dynprop;

import java.io.*;
import java.util.*;
import org.omg.CORBA.*;

public class DynPropDemo
{
    public static void main(String[] args)
    {
	String iorfile = null;

	int argc = 0;
	while (argc < args.length) {
	    if (args[argc].equals("-i")) {
		argc++;
		if (argc < args.length)
		    iorfile = args[argc];
		else
		    usage();
	    }

	    argc++;
	}

	// initialize the ORB
	ORB orb = org.omg.CORBA.ORB.init(args, null);

	// create the dynamic property evaluation implementation

	DynamicPropEvalImpl impl = new DynamicPropEvalImpl();
	impl._this_object( orb );

	// write the IOR of the object (if necessary)
	if (iorfile != null) {
	    try {
		FileOutputStream out = new FileOutputStream(iorfile);
		PrintWriter pw = new PrintWriter(out);
		pw.println(orb.object_to_string(impl._this()));
		pw.flush();
		out.close();
	    }
	    catch (IOException e) {
		System.err.println("Unable to write IOR to file " + iorfile);
		System.exit(1);
	    }
	}

	// GB:
	orb.run();

	System.exit(0);
    }


    protected static void usage()
    {
	System.err.println("Usage: jtdemo.dynprop.DynPropDemo [-i iorfile]");
	System.exit(1);
    }
}




