package jacorb.security.level2;

/*
 *        JacORB - a free Java ORB
 *
 *   Copyright (C) 1997-99  Gerald Brose.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

import org.omg.Security.*;
import java.util.Vector;

/**
 *  JacORB implementation of security Credentials
 *
 * @author Christophe Andrey, Gerald Brose
 * @version  $Id: ReceivedCredentials.java,v 1.1 2000/03/27 09:50:04 brose Exp $
 *
 */

public class ReceivedCredentials
    extends jacorb.security.level2.Credentials
    implements org.omg.SecurityLevel2.ReceivedCredentials
{
    private org.omg.Security.DelegationState delegation_state;
    private org.omg.Security.DelegationMode delegation_mode;

    public ReceivedCredentials(PrincipalAuthenticator authenticator,
			       java.security.cert.X509Certificate [] listOfCert,
			       org.omg.Security.AuthenticationStatus authStatus,
			       org.omg.Security.DelegationState delegation_state, 
			       org.omg.Security.DelegationMode delegation_mode )
    {
	super(authenticator, listOfCert, authStatus);
	this.delegation_state = delegation_state;
	this.delegation_mode = delegation_mode;
    }
  
    public org.omg.SecurityLevel2.Credentials accepting_credentials()
    {
	return null;
    }

    public short association_options_used()
    {
	return -1;
    }

    public org.omg.Security.InvocationCredentialsType credentials_type()
    {
	return org.omg.Security.InvocationCredentialsType.SecReceivedCredentials;
    }

    public org.omg.Security.DelegationState delegation_state()
    {
	return delegation_state;
    }

    public org.omg.Security.DelegationMode delegation_mode()
    {
	return delegation_mode;
    }
}





