package jacorb.orb.domain.test;

import jacorb.orb.domain.Domain;
import jacorb.util.Debug;
import java.io.*;
/**
 * Util.java
 * a utility class with some useful static functions
 *
 * Created: Thu Jan 13 14:16:16 2000
 *
 * @author Herbert Kiefer
 * @version $Revision: 1.6 $
 */
public class Util  {

  /** used for echoing reads to a file */
  private static PrintWriter _out= null;

  /** displays a menu and reads a choice */
  public static int textmenu(String[] entries)
  {
    // i is index for array, j is printed out
    int i, j=0, answer= -1;
    while (answer < 1 || answer > entries.length) 
      {
	System.out.println();
	i= 0; j=0; 
	while (i < entries.length) // print menu 
	  {
	    if ( entries[i].charAt(0) == '-')
	         System.out.println(" "+          "\t " + entries[i]);
	    else System.out.println(" "+ (++j) + ")\t " + entries[i]);
	    i++;
	  }
	System.out.print("choice(1-" + j+ "): ");
	answer= readInt(System.in);
	// System.out.println("answer is " + answer);
      }
    return answer;
  } // textmenu

  /** reads an int from standard input */
 public static int readInt() { return readInt(System.in); }

  /** reads an int from InputStream in */
  public static int readInt(InputStream in)
  {
    int result= -1;
    DataInputStream input= new DataInputStream((in));
    String line;

    try { line= input.readLine(); }
    catch (IOException e){ 
      System.out.println("readInt: couldn't read line."); return -1;
    }

    // System.out.println("line is: " + line);
    try { result= Integer.parseInt(line); }
    catch (NumberFormatException e) { 
      System.out.print("readInt: couln't convert input to int, try again: ");
      result= readInt(in);
    }
    // System.out.println("answer is " + result);
    
    if (_out != null) // echo result to file
      {
	_out.println(result);
	_out.flush();
      }

    return result;
  } // readInt

  /** reads an char from standard input */
  public static char readChar() { return readChar(System.in); } 

  /** reads an char from InputStream in */
  public static char readChar(InputStream in)
  {
    char result= '?';
    DataInputStream input= new DataInputStream(in);
   
    
    String line;
    try { line= input.readLine(); }
    catch (IOException e){ 
      System.out.println("readChar: couldn't read line."); return '?';
    }
    try { result= line.charAt(0); }
    catch (Exception e) { 
      System.out.print
	("readChar: couln't convert input to char, try again: ");
      result= readChar(in);
    }
    //        System.out.println("answer is " + result);
    
    if (_out != null) // echo result to file
      {
	_out.println(result);
	_out.flush();
      }

    return result;
  } // readChar

  /** enables echoing for readInt and readChar to a file */
  public  static void FileEchoOn(String filename)
  {
    if (_out == null) 
      {
	try 
	  {
	    FileOutputStream file = new FileOutputStream(filename);
	    _out = new PrintWriter(file);
	  } 
	catch (java.io.FileNotFoundException notFound) 
	  {
	    System.out.println(" file " + filename + " not found.");
	  }
	catch (java.io.IOException ioex) 
	  {
	    jacorb.util.Debug.output(2,ioex) ;
	  }
      }
  }

 /** disables echoing for readInt and readChar */
  public  static void FileEchoOff()
  {
    if (_out != null) 
      {
	_out.flush();
	_out.close();
	_out = null;
      }
  }

  /** sorts an array of strings in alphabetical order. */
  public static void quicksort (int links, int rechts, Domain[] array)
  { 
    if (links < rechts)
      {
	// int el= findEl(links,rechts,arr);
	String el= array[links].description(); //findMiddle(links,rechts,arr);
	int i=links, j=rechts;
	while (i<=j)
	  {
	    while (array[i].description().compareTo(el) < 0) i++;
	    // while (array[i] < el) i++;
	    while (array[j].description().compareTo(el) > 0) j--;
	    // while (array[j] > el) j--;
	    if (i<=j) {swap(i,j, array); i++; j--; }
	  }
	quicksort(links,j,array);
	quicksort(i,rechts,array);
      }
  }

  /** swaps the contents of an array determined by the two indexes. */
  public static void swap(int i, int j, Domain[] array)
  { 
    Domain temp=array[i]; 
    array[i]= array[j];
    array[j]= temp; 
  }


} // Util
