package jacorb.orb;

/*
 *        JacORB - a free Java ORB
 *
 *   Copyright (C) 1997-98  Gerald Brose.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


import java.io.*;
import java.lang.*;
import org.omg.CORBA.ORB;

/**
 * @author Gerald Brose, FU Berlin 1996
 * $Id: ReplyReceptor.java,v 1.8 2000/03/31 08:57:09 brose Exp $	
 *
 * An object of this class is created for every connection and listens
 * for replies.
 */

class ReplyReceptor extends Thread 
{
    private boolean stopped = false;

    Connection master;

    public ReplyReceptor( Connection _master )
    {
	master = _master;
	try
	{
	    setDaemon( true );
	}
	catch( java.lang.SecurityException s)
	{
	    jacorb.util.Debug.output(3,"Could not start reply receptor as daemon, running as a regular thread.");
	}
	this.setName("JacORB ReplyReceptor Thread for connection " + master.getInfo() );
	start();
    }

    public void stopReceptor()
    {
	stopped = true;
	interrupt();
    }


    public void run() 
    {	
	while( true )
	{
	    try
	    {
		master.receiveReply();
	    }
	    catch ( CloseConnectionException c )
	    {
		jacorb.util.Debug.output(3, "ReplyReceptor: CloseConnectionException");
		master.closeConnection();
		break;
	    }
	    catch ( java.io.InterruptedIOException ioint )
	    {		
		// when the receptor is interrupted from within
		// Connection.closeConnection
		jacorb.util.Debug.output(3,ioint);
		break;
	    }
	    catch ( IOException e )
	    {
		jacorb.util.Debug.output(3,e);
		if( ! stopped )
		    master.closeConnection();
		break;
	    }
	    catch ( Exception ie )
	    {
		jacorb.util.Debug.output(3,ie);
	    }
	}
    }
}


