package jacorb.imr;

import jacorb.orb.*;
/**
 * This class represents a host. It contains information about 
 * a server startup daemon residing on this host and provides
 * a method for starting a server on that host.
 *
 * @author Nicolas Noffke
 * 
 * $Log: ImRHostInfo.java,v $
 * Revision 1.5  1999/11/25 16:04:53  brose
 * cosmetics
 *
 * Revision 1.4  1999/11/09 10:59:26  brose
 * new GUI version
 *
 * Revision 1.2  1999/10/29 19:24:29  noffke
 * Cosmetics, now fully commented , adapted to new/altered methods from the
 * interface
 *
 *
 */

public class ImRHostInfo implements java.io.Serializable {
    protected String m_host;

    private ServerStartupDaemon m_ssd_ref;
    private String m_object_string;

    private boolean m_reconnect = false;
    
    /**
     * The constructor of this class.
     *
     * @param host the HostInfo object to take the information from.
     * @param orb needed for calling object_to_string().
     **/
    public ImRHostInfo(HostInfo host) {
	m_host = host.name;
	m_ssd_ref = host.ssd_ref;
	m_object_string = host.ior_string;
    }
    
    /**
     * "Convert" this object to a HostInfo object
     *
     * @return a HostInfo instance
     **/
    public HostInfo toHostInfo(){
	// setting ref explicitely to null since it might be stale.
	return new HostInfo(m_host, null, m_object_string);
    }

    /**
     * This method tries to start a server with the daemon for this host.
     *
     * @param command the startup command of the server
     * @param orb needed for calling string_to_object().
     * @exception ServerStartupFailed propagated up from the daemon if something
     * went wrong. Likely to throw CORBA System Exceptions as well, especially
     * if the daemon is down.
     **/
    public void startServer(String command, ORB orb) 
	throws jacorb.imr.ServerStartupDaemonPackage.ServerStartupFailed{
       
	if (m_reconnect)
	    m_ssd_ref = ServerStartupDaemonHelper.narrow(orb.string_to_object(m_object_string));

	m_ssd_ref.start_server(command);
    }

    /**
     * Things to be done before serialization. Implemented from Serializable. 
     **/
    private void writeObject(java.io.ObjectOutputStream out)
	throws java.io.IOException{

	m_reconnect = true; // all ssd_references are stale after deserialization
	out.defaultWriteObject();
    }
} // ImRHostInfo


