/*
 *        JacORB - a free Java ORB
 *
 *   Copyright (C) 1997-98  Gerald Brose.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jacorb.idl;

import java.util.Vector;
import java.util.Enumeration;
import java.io.*;

/**
 * @author Gerald Brose
 * @version 1.0, 10 Dec 1998
 */


class Spec 
    extends IdlSymbol
{
    public Vector definitions;

    public Spec(int num)
    {
	super(num);
	definitions = new Vector();
    }

	public void parse() 
		 
	{
		Enumeration e = definitions.elements();
		for(; e.hasMoreElements(); )
			((IdlSymbol)e.nextElement()).parse();
	}

    public void setPackage( String s, boolean propagate_into_included )
    {
        s = parser.pack_replace(s);
	Enumeration e = definitions.elements();
	while( e.hasMoreElements() )
	{
	    IdlSymbol i = (IdlSymbol)e.nextElement();
	    i.setPackage( s, propagate_into_included);
	}
    }

    public void print(PrintWriter ps)
    {
	Enumeration e = definitions.elements();
	while( e.hasMoreElements() )
			((IdlSymbol)e.nextElement()).print(ps);
    }	
}







