/*
 *        JacORB - a free Java ORB
 *
 *   Copyright (C) 1997-98  Gerald Brose.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/**
 * @author Gerald Brose
 * @version $Id: MemberList.java,v 1.5 1999/11/25 16:04:04 brose Exp $
 * $Log: MemberList.java,v $
 * Revision 1.5  1999/11/25 16:04:04  brose
 * cosmetics
 *
 * Revision 1.4  1999/11/04 16:59:20  brose
 * (setPackage): changed signature to include a boolean arg that
 * determines whether setPackage is also done in included files
 *
 * Revision 1.2  1999-08-06 13:27:53+02  brose
 * Removed references to ParseError
 *
 * Revision 1.1.1.1  1999-08-05 12:22:11+02  brose
 * First initial preliminary ... attempt
 *
 * Revision 1.1  1999-07-29 13:27:45+02  brose
 * Initial revision
 *
 * Revision 1.3  1999-07-19 18:10:39+02  brose
 * corrected how enclosing symbols get set
 *
 */

package jacorb.idl;

import java.util.Vector;
import java.util.Enumeration;
import java.io.*;

class  MemberList
    extends SymbolList
{
    Vector extendVector = new Vector();
    private StructType containing_struct;
    private boolean parsed = false;

    public MemberList(int num)
    {
	super(num);
    }

    public void setStruct(StructType s)
    {
	containing_struct = s;
	Enumeration e = v.elements();
	for(; e.hasMoreElements(); )
	{
	    Member m = (Member)e.nextElement();
	    m.setStruct( s );
	}
    }

    public void parse() 
	 
    {
	if( parsed)
	    throw new RuntimeException("Compiler error: MemberList already parsed!");

	Enumeration e = v.elements();
	for(; e.hasMoreElements(); )
	{
	    Member m = (Member)e.nextElement();
	    m.setExtendVector( extendVector );
	    m.parse();
	}

	/* after all members are parsed, we have accumulated
	   a new member list in "normal form" in extendVector
	*/

	v = extendVector;
	parsed = true;

    }

    public void setEnclosingSymbol( IdlSymbol s )
    {
	if( enclosing_symbol != null && enclosing_symbol != s )
	{
	    throw new RuntimeException("Compiler Error: trying to reassign container");
	}

	enclosing_symbol = s;

	for(Enumeration e = v.elements(); e.hasMoreElements(); )
	{
	    Member m = (Member)e.nextElement();
	    m.setEnclosingSymbol(s);
	}

    }


}







