/*
 *        JacORB - a free Java ORB
 *
 *   Copyright (C) 1997-98  Gerald Brose.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jacorb.orb.giop;

/**
 * @author Gerald Brose, FU Berlin
 * @version $Id $
 */

import java.io.*;
import java.lang.*;
import jacorb.orb.*;

public class LocateRequest 
    extends jacorb.orb.dsi.ServerRequest 
{
    jacorb.orb.giop.LocateRequestInputStream in;

    public LocateRequest( byte[] _buf, jacorb.orb.Connection _connection )
    {
	in = new jacorb.orb.giop.LocateRequestInputStream(_connection,_buf);
	connection = _connection;

	oid = jacorb.poa.util.POAUtil.extractOID( in.req_hdr.object_key);
    }

    public java.lang.String operation()
    {
	return "_non_existent";
    }

    public int requestId()
    {
	return in.locate_req_hdr.request_id;
    }

    public byte[] objectKey()
    {
	return in.locate_req_hdr.object_key;
    }

    public void reply()
    {       
	try 
	{ 
	    if( out == null )
	    {
		out = new jacorb.orb.giop.ReplyOutputStream(connection,
													new org.omg.IOP.ServiceContext[0],
							    requestId(), 
							    org.omg.GIOP.ReplyStatusType.from_int(status));
	    }

	    /* DSI-based servers set results and user exceptions using anys, so 
	       we have to treat this differently */

	    if( !stream_based )
	    {
		if( status == org.omg.GIOP.ReplyStatusType._USER_EXCEPTION )
		{
		    out.write_string( ex.type().id() );
		    ex.write_value( out );
		}
		else if( status == org.omg.GIOP.ReplyStatusType._NO_EXCEPTION )
		{
		    result.write_value( out );
		}
	    }

	    /* these two exceptions are set in the same way for both stream-based and
	       DSI-based servers */
	    
	    if( status == org.omg.GIOP.ReplyStatusType._LOCATION_FORWARD )
	    {
		out.write_Object( location_forward.forward_reference );
	    }
	    else if( status == org.omg.GIOP.ReplyStatusType._SYSTEM_EXCEPTION )
	    {
		jacorb.orb.SystemExceptionHelper.write( out, sys_ex );
	    }
	    
	    /* everything is written to out by now, be it results or exceptions */
	    
	    out.close();
	    int reply_status;
	    if( status != org.omg.GIOP.ReplyStatusType._NO_EXCEPTION
		// || _non_existent()
		)
	    {
		reply_status = org.omg.GIOP.LocateStatusType._UNKNOWN_OBJECT;
	    }
	    else
	    {
		reply_status = org.omg.GIOP.LocateStatusType._OBJECT_HERE;
	    }
	    connection.sendLocateReply( requestId(), reply_status , null );	    
	}
	catch ( Exception ioe )
	{
				// debug:
	    ioe.printStackTrace();
	    System.err.println("ServerRequest: Error replying to request!");
	}
    }
}



