package jacorb.orb.domain.test;

import jacorb.orb.domain.*;
import org.omg.CosNaming.*;
import jacorb.util.Debug;
import java.io.*;

/**
 * DomainTesterClient.java
 * a testing client for DomainImpl.java
 *
 * Created: Tue Jan  4 2000
 *
 * @author Herbert Kiefer
 * @version $Revision: 1.1 $
 */
public class DomainTesterClient  {
 public static void main( String[] args ) 
  {
    try 
      {
	Util.FileEchoOn("fileOutput");
	new DomainTesterClient(null, args);
	Util.FileEchoOff();

      }
    catch (Exception e)
      {
	e.printStackTrace();
	Util.FileEchoOff();
      }
  } // main

  // dom is domain to test
  DomainTesterClient(Domain dom, String[] args) {

    int n= 10;
    Domain dm[]= new Domain[n];
    Domain domain= null ;
    Domain[] dmList;
    TestPolicy pol[]= new TestPolicy[n];

    int i;
    String submenu[]= null;
    org.omg.CORBA.Policy policy=     null;
    TestPolicy           testPolicy= null;
    String [] lines={
      "insert member", 
      "delete member",
      "has    member",
      "list   member", 
      "-------------", 
      "get         policy", 
      "set         policy", 
      "get default policy type",
      "set default policy type",
      "-----------------------", 
      "create domain                ",
      "get domains from name service",
      "-----------------------------",
      "insert child domain   ", 
      "delete child domain   ",
      "has    child domain   ",
      "list   child domains  ", 
      "goto   child domain...",
      "-----------------------",
      "insert parent domain   ",
      "delete parent domain   ",
      "has    parent domain   ",
      "list   parent domains  ",
      "goto   parent domain...",
      "-----------------------", 
      "get policy         ", 
      "get domain managerns", 
      "-------------------", 
      "check if is root ",
      "get root domain  ",
      "list slot content",
        "finish"};
    int count= 0;
    org.omg.CORBA.ORB orb= null;
    NamingContextExt nc= null;
  
    try
      { // get name service
	orb = org.omg.CORBA.ORB.init(args,null);
	nc = NamingContextExtHelper.narrow
	  (orb.resolve_initial_references("NameService"));

	
	if (dom == null) {

	// get domain service
	dom= DomainHelper.narrow(nc.resolve(nc.to_name("Domain.service")));
	} // else use given one
	else System.out.println("observing domain " + dom.description() );

	// get test policies
	for (i= 0; i < n; i++) 
	  {
	    pol[i]= TestPolicyHelper.narrow(nc.resolve(nc.to_name("TestPolicy"+i+".whatever")));
	    // System.out.println("got " + pol[i].description());
	  }

	} catch (Exception e) {
	  Debug.output(1,e);
	}

    // get test domains 
    for (i= 0; i < n; i++) 
	  {
	    try 
	      {
		domain= DomainHelper.narrow( nc.resolve(nc.to_name("Domain"+i+".whatever") ) );
	      }
	    catch (org.omg.CosNaming.NamingContextPackage.NotFound e) 
	      {
		jacorb.util.Debug.output(2, "domain "+ i + " not found at name server");
		continue;
	      }
	    catch (Exception e) { e.printStackTrace(); }
	    dm[i]= domain;
	  }

    // main loop
    boolean end= false;
    int j, answer;

  try {
    while (!end)
     
      {
	System.out.println("current: "+ dom.description());
	answer= Util.textmenu(lines);
	System.out.println(" choice was " + answer);
	switch (answer) {

	case 1: // insert member
	  System.out.print("insert which member ? ");
	  dom.insertMember(pol[Util.readInt()]); 
	  break;

	case 2: // delete member
	  System.out.print("delete which member ? ");
	  dom.deleteMember(pol[Util.readInt(System.in)]); 
	  break;

	case 3: // has member
	  System.out.print("check which member ? ");
	  if ( dom.hasMember(pol[Util.readInt()]) ) System.out.println("yes");
	  else System.out.println("no");
	  break;
	

	case 4: // list members
	  org.omg.CORBA.Object[] members= dom.getMembers();
	  for (i= 0; i < members.length; i++) 
	    System.out.println(TestPolicyHelper.narrow(members[i])._toString());
	  break;

	case 5: // get policy
	  System.out.println("get which type ?:");
	  try 
	    {
	      policy= dom.get_domain_policy( Util.readInt() );
	    }
	  catch (org.omg.CORBA.INV_POLICY inv) 
	    {
	      System.out.println("this domain has no policy of this type");
	      break;
	    }
	      
	  testPolicy= TestPolicyHelper.narrow(policy);
	  if (testPolicy != null)
	    System.out.println("returned policy is " + testPolicy._toString());
	  else // cast failed
	    {
	      System.out.println("returned policy is " + policy);

	    }
	  break;

	case 6: // set policy
	  System.out.println("set which type (only slot#) ?:");
	  dom.set_domain_policy(pol[Util.readInt()]);
	  break;

	case 7: // get default policy type
	  System.out.println("default policy type is " +  dom.defaultPolicyType() );
	  break;

	case 8: // set default policy type
	  System.out.print("choose from 1 to 9: ");
	  dom.defaultPolicyType( pol[ Util.readInt() ].policy_type() );
	  break;

	case 9: // create domain
	  try {
	  System.out.print("into which slot ? :");
	  // for (i= 0; i < n; i++) System.out.println(pol[i].description());

	  dm[j= Util.readInt()]= dom.createDomain
	    (pol, pol, pol[0].policy_type(), "dm # "+j);
	  // dom.insertChild(dm[j]);
	  System.out.print("register at name service ? (y/n) ");
	  if (Util.readChar() != 'n') 
	    {
	      nc.bind(nc.to_name("Domain"+j+".whatever"), dm[j]); 
	    }
	  }
	  catch (Exception e) { e.printStackTrace(); }
	  break;

	case 10: // get domains from name service
	  for (i= 0; i < n; i++) {
	    try { dm[i]= DomainHelper.narrow(nc.resolve(nc.to_name("Domain"+i+"whatever"))); }
	    catch (org.omg.CosNaming.NamingContextPackage.NotFound e) {
	      System.out.println("dm # "+i+" not found at name service");
	    }
	  }
	  break;
	  
	case 11: //  insert child domain 
	  System.out.print("take child domain from which slot ?");
	  dom.insertChild( dm[Util.readInt()] );
	  break;

	case 12: // delete child domain
	  System.out.println("which one ? (slot#): ");
	  dom.deleteChild(dm[Util.readInt()]);
	  break;

	case 13: // has child domain
	  System.out.println("check which domain (slot#) ? ");
	  if ( dom.hasChild(dm[Util.readInt()]) ) System.out.println("yes");
	  else System.out.println("no");
	  break;

	case 14: // list child domains
	  dmList= dom.getChilds();

	  // System.out.println("list before sort:");
	  // for (i= 0; i < dmList.length; i++) 
	  // System.out.println(dmList[i].description());

	  Util.quicksort(0, dmList.length-1, dmList);
	  // System.out.println("list after sort:");
	  for (i= 0; i < dmList.length; i++) 
	    System.out.println(dmList[i].description());
	  break;

	case 15: // goto child domain
	  dmList= dom.getChilds();
	  if (dmList.length == 0) break;
	  Util.quicksort(0, dmList.length-1, dmList);
	  submenu= new String[dmList.length];
	  for (i= 0; i < dmList.length; i++) 
	    submenu[i]= dmList[i].description();
	  answer= Util.textmenu(submenu);
	  System.out.println(" choice was " + answer+ " which is " + dmList[answer-1].description());
	  new DomainTesterClient(dmList[answer-1], args);
	  break;

	case 16: // insert parent domain
	  System.out.print("insert which parent (slot # from 1 to 9) ? : ");
	  dom.insertParent(dm[Util.readInt()]);
	  break;

	case 17: // delete parent domain
	  System.out.print("delete which parent (slot # from 1 to 9) ? : ");
	  dom.deleteParent(dm[Util.readInt()]);
	  break;

	case 18: // has parent domain
	  System.out.println("check which domain (slot#) ? ");
	  if ( dom.hasParent(dm[Util.readInt()]) ) System.out.println("yes");
	  else System.out.println("no");
	  break;

	case 19: // list parent domains
	  Domain[] domainList= dom.getParents();
	  Util.quicksort(0, domainList.length-1, domainList);
	  for (i= 0; i < domainList.length; i++) 
	    System.out.println(domainList[i].description());
	  break;

	case 20: // goto parent domain...
	  dmList= dom.getParents();
	  if (dmList.length == 0) break;
	  Util.quicksort(0, dmList.length-1, dmList);
	  submenu= new String[dmList.length];
	  for (i= 0; i < dmList.length; i++) 
	    submenu[i]= dmList[i].description();
	  answer= Util.textmenu(submenu);
	  System.out.println(" choice was " + answer+ " which is " + dmList[answer-1].description());
	  new DomainTesterClient(dmList[answer-1], args);
	  break; 

	case 21: // get policy
	  System.out.println("of which object ?: ");
	  i= Util.readInt();
	  System.out.println
	    ("policy is :"+TestPolicyHelper.narrow
	     (dom.getPolicy(pol[i],i))._toString() );
	  break;

	case 22: // get domains
	  System.out.println("of which object ?: ");
	  dmList= dom.getDomains(pol[Util.readInt()]);
	  Util.quicksort(0, dmList.length-1, dmList);
	  for (i= 0; i < dmList.length; i++) 
	    System.out.println(dmList[i].description());
	  break;

	case 23: // check if is root 
	   if ( dom.isRoot() ) 
	    System.out.println("domains "+ dom.description() + "is a root domain");	  
	   else   System.out.println("domains "+ dom.description() + " is NOT a root domain");	
	  break;

	case 24: // get root domain 
	  domain= dom.getRootDomain();
	  System.out.print("the root is " + domain.description() + ". GOTO ? ");
	  if (Util.readChar() == 'y') 
	    new DomainTesterClient(domain, args);
	  break;
	

	case 25: // list slot contents
	  System.out.println("\t slot # \t description");
	  for (i= 0; i < n; i++) 
	    {
	      System.out.print("\t " + i + "\t");
	      if (dm[i] != null)
		System.out.println(dm[i].description());
	      else System.out.println("is null");

	    }
	    

	  break;

	case 26: 
	  end= true; 
	  break;
	}
      }
  } 
  catch (Exception e) 
    { 
      e.printStackTrace(); 
    }
  }
} // DomainTester

