/*
 *        JacORB - a free Java ORB
 *
 *   Copyright (C) 1997-98  Gerald Brose.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jacorb.idl;

/**
 * JacORB  IDL compiler classes
 *
 * @author Gerald Brose
 * @version $Id: Module.java,v 1.7 1999/12/10 15:44:06 brose Exp $
 */

import java.util.Vector;
import java.util.Enumeration;
import java.io.*;

/**
 * Note: a module's name is its package name!
 */


class Module 
    extends Declaration
{
    public Definitions spec;

    private String versionPrefix = "";
    //private String _package = "";


    public Module(int num)
    {
	super(num);
	pack_name = "";
    }

    public void setPackage( String s, boolean propagate_into_included )
    {	
        s = parser.pack_replace(s);

	if( pack_name.length() > 0 )
	{
	    pack_name = new String( s + "." + pack_name );
	    spec.setPackage(s, propagate_into_included);
	}
	else
	{
	    pack_name = s;

	    if( lexer.needsJavaEscape( this ))
		pack_name = "_" + s;

	    name = pack_name;
	    spec.setPackage(pack_name, propagate_into_included);
	}

    }

    String full_name()
    {
	return pack_name;
    }

    public void set_included(boolean i)
    {
	included = i;
	spec.set_included(i);
    }

    public void setEnclosingSymbol( IdlSymbol s )
    {
	if( enclosing_symbol != null && enclosing_symbol != s )
	    throw new RuntimeException("Compiler Error: trying to reassign container for " + name );
	enclosing_symbol = s;
	spec.setEnclosingSymbol(this);
    }

    public void parse()	
    {
	spec.parse();
    }
	
    public void print(PrintWriter ps)
    {
	spec.print(ps);
	//	IRMap.enter(this);
    }
}







