/*
 *        JacORB - a free Java ORB
 *
 *   Copyright (C) 1997-98  Gerald Brose.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jacorb.idl;

import java.util.*;
import java.io.*;

public class IRMap
{
    public static final String mapFilename = "_irmap";

    private static Hashtable entries = new Hashtable();
    private static File file;

    public static void update(File f)
    {
	file = f;
	Hashtable old_entries = null;
	if( f.length() > 0 )
	{
	    try
	    {
		ObjectInputStream oi = new ObjectInputStream(new FileInputStream(f));
		old_entries = (Hashtable)oi.readObject();
	    }
	    catch( Exception ioe)
	    {
		ioe.printStackTrace();
		System.exit(1);
	    }
	    for( Enumeration enum = entries.keys(); enum.hasMoreElements(); )
	    {
		String key = (String)enum.nextElement();
		Entry e = (Entry)entries.get( key );
		if( old_entries.containsKey( key ) && ( entries.get(key).equals(e) ))
		{
		    Environment.output(2,"replacing entry " + key );
		    old_entries.remove(key);
		}
		old_entries.put(key,e);
	    }
	}
	else
	    old_entries = entries;

	
	try
	{
	    ObjectOutputStream oi = new ObjectOutputStream(new FileOutputStream(file));
	    oi.writeObject(old_entries);
	}
	catch( Exception ioe)
	{
	    ioe.printStackTrace();
	    System.exit(1);
	}
    }

    public static void enter(IdlSymbol s)
    {
	if( !parser.generateIRMap )
	    return;

	Entry e = s.getEntry();

	Environment.output(2, "IR Map entry: " + e.key());
	if( entries.containsKey( e.key() ) && ( entries.get(e.key() ).equals(e) ))
	{
	    Environment.output(2,"replacing entry " + e.key());
	    entries.remove(e.key() );
	}
	entries.put(e.key(), e);
    }

}







