/*
 *        JacORB - a free Java ORB
 *
 *   Copyright (C) 1997-98  Gerald Brose.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jacorb.idl;

import java.util.*;

public class Entry
    implements java.io.Serializable
{    
    public final static String separator = " ";

    private String repId;
    private String className;
    private String kindOfType;
    private Hashtable contents;
    private String generic;

    public Entry(String qn, String ri, String kot, String gen)
    {
	className = qn;
	repId = ri;
	kindOfType = kot;
	generic = gen;
    }

    public Entry(String qn, String ri, String kot, Hashtable conts, String gen)
    {
	className = qn;
	repId = ri;
	kindOfType = kot;
	contents = conts;
	generic = gen;
    }

    public String toString()
    {
	return className + separator + repId  + separator + kindOfType;
    }

    public int hashCode()
    {
	return key().hashCode();
    }

    public boolean equals(Object o)
    {
	return ( o instanceof Entry && hashCode() == o.hashCode());
    }

    public String key()
    {
	return className;
    }

    public String kind()
    {
	return kindOfType;
    }

    public String id()
    {
	return repId;
    }

    public Hashtable contents()
    {
	return contents;
    }

}




