/*
 *        JacORB - a free Java ORB
 *
 *   Copyright (C) 1997-98  Gerald Brose.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package demo.interceptors.proprietary;

public class TraceServerRequestInterceptor 
	implements jacorb.orb.ServerRequestInterceptor
{
    private int indent = 0;
    private long start = 0;

    public TraceServerRequestInterceptor(){}

    public  void pre_invoke( org.omg.CORBA.ServerRequest r )
    {
		for( int i = 0; i < indent; i++ )
			System.out.print(" ");
		System.out.println("[ invoke (" + r.operation() + ") ]");
		if( r.operation().startsWith("write"))
		{
			org.omg.CORBA.Any any = org.omg.CORBA.ORB.init().create_any();
			org.omg.CORBA.NVList nvlist = org.omg.CORBA.ORB.init().create_list(0);
			any.insert_long( 0 );
			nvlist.add_value("arg1", any, org.omg.CORBA.ARG_IN.value );
			r.arguments(nvlist);
			jacorb.util.Debug.output(1, "op: " + r.operation() + " arg: " + any.extract_long());
		}
		start = System.currentTimeMillis();
		indent += 2;
    }

    public  void post_invoke( org.omg.CORBA.ServerRequest r )
    {
		indent -= 2;
		for( int i = 0; i < indent; i++ )
			System.out.print(" ");
		System.out.println("[ (" + r.operation() + ") returns after " +
						   (System.currentTimeMillis()-start) + " ms ]");
    }

}





