/*
 *        JacORB - a free Java ORB
 *
 *   Copyright (C) 1997-98  Gerald Brose.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package demo.interceptors.proprietary;

/** 
 * a simple request interceptor
 */

import jacorb.util.Debug;

public class TraceClientRequestInterceptor
    implements jacorb.orb.ClientRequestInterceptor
{
    int indent;

    public TraceClientRequestInterceptor(){}

    public void pre_invoke( org.omg.CORBA.Request r )
    {
		StringBuffer indentation = new StringBuffer();
		for( int i = 0; i < indent; i++ )
			indentation.append(" ");
		Debug.output(1, indentation.toString() +  "invoke " + r.operation());
		indent += 2;
    }

    public void post_invoke( org.omg.CORBA.Request r )
    {
		StringBuffer indentation = new StringBuffer();
		indent -= 2;
		for( int i = 0; i < indent; i++ )
			indentation.append(" ");
		Debug.output(1,indentation.toString() + r.operation() + " returns");
    }

}


