package demo.interceptors.proprietary;

import org.omg.CORBA.Any;
import org.omg.CosNaming.*;

/**
 *	Example Server using interceptors and the DSI
 *
 * NOTE: You must enable all side-side interceptors in the 
 * jacorb properties file or on the command line for this example 
 * to work!
 */

public class RedirectionServer
    extends org.omg.PortableServer.DynamicImplementation
{
    private String[] ids = {"IDL:demo/interceptors/proprietary/MyServer:1.0"};
    org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init();
    serverImpl impl = new serverImpl();

    public String[] _all_interfaces(org.omg.PortableServer.POA poa, byte[] objectId)
    {
	return ids;
    }

    public void invoke(org.omg.CORBA.ServerRequest r) 
    {
	jacorb.orb.dsi.ServerRequest request = (jacorb.orb.dsi.ServerRequest)r;
	String op = request.op_name();
	try 
	{
	    if( op.equals("writeNumber") )
	    {
		System.out.println("Server2 got request!");
		org.omg.CORBA.NVList params = orb.create_list(0);
		Any numAny = orb.create_any();
		numAny.type( orb.get_primitive_tc(
						  org.omg.CORBA.TCKind.tk_long));
		params.add_value( "", numAny, 0 );
		request.arguments( params );
		Any a = orb.create_any();
		a.insert_string( impl.writeNumber( numAny.extract_long() ));
		request.set_result( a );
	    } 
	    else if( op.equals("writeNumberWithEx") )
	    {
		System.out.println("Server2 got request!");
		org.omg.CORBA.NVList params = orb.create_list(0);
		Any numAny = orb.create_any();
		numAny.type( orb.get_primitive_tc(
						  org.omg.CORBA.TCKind.tk_long));
		params.add_value( "", numAny, 0 );
		request.arguments( params );
		Any a = orb.create_any();
		a.insert_string( impl.writeNumberWithEx( numAny.extract_long() ));
		request.set_result( a );
	    } 
	    else if( op.equals("_notify") )
	    {
		System.out.println("Server2 got request!");
		org.omg.CORBA.NVList params = orb.create_list(0);
		Any stringAny = orb.create_any();
		stringAny.type( orb.get_primitive_tc(
						     org.omg.CORBA.TCKind.tk_string));
		params.add_value( "", stringAny, 0 );
		request.arguments( params );
		impl._notify( stringAny.extract_string() );
		Any s = orb.create_any();
		s.type( orb.get_primitive_tc(org.omg.CORBA.TCKind.tk_void ));
		request.set_result( s );
	    } 
	    else if( op.equals("_non_existent") )
	    {
		System.out.println("Server2 got request!");
		Any s = orb.create_any();
		s.type( orb.get_primitive_tc(org.omg.CORBA.TCKind.tk_boolean ));
		s.insert_boolean( _non_existent());
		request.set_result( s );
	    }
	    /** 
	     * the following operations would also have to be implemented 
	     * by delegating to the superclass DynamicImplementation or Servant
	     * but are omitted here for brevity
	     */
	    else if( op.equals("_all_interfaces") )
	    {
		System.out.println("Server2 got request!");
		throw new org.omg.CORBA.BAD_OPERATION("Object reference operations not implemented in example!");	    
	    }
	    else if( op.equals("_get_interface") )
	    {
		System.out.println("Server2 got request!");
		throw new org.omg.CORBA.BAD_OPERATION("Object reference operations not implemented in example!");	    
	    }
	    else if( op.equals("_is_a") )
	    {
		System.out.println("Server2 got request!");
		org.omg.CORBA.NVList params = orb.create_list(0);
		Any stringAny = orb.create_any();
		stringAny.type( orb.get_primitive_tc(org.omg.CORBA.TCKind.tk_string));
		params.add_value( "", stringAny, 0 );
		request.arguments( params );

		Any s = orb.create_any();
		s.type( orb.get_primitive_tc(org.omg.CORBA.TCKind.tk_boolean ));
		s.insert_boolean( _is_a(stringAny.extract_string() ));
		request.set_result( s );
	    }
	    else 
	    {
		System.out.println("Server2 got request!");
		throw new org.omg.CORBA.BAD_OPERATION(op + " not found.");
	    }
	} 
	catch ( org.omg.CORBA.UserException e )
	{
	    Any exceptAny = orb.create_any();
  	    try 
  	    {
		Class helperClass = Class.forName( e.getClass().getName() + "Helper");
		Class anyClass = Class.forName("org.omg.CORBA.Any");
		java.lang.reflect.Method insert = 
		    helperClass.getDeclaredMethod("insert", 
						  new Class[] { anyClass, e.getClass() });

		insert.invoke( null, new java.lang.Object[]{exceptAny, e});
  	    } 
	    catch(  Exception sfe )
	    {
		sfe.printStackTrace();
	    }
	    request.set_exception( exceptAny );	    
	} 
	catch ( Exception e )
	{
	    e.printStackTrace();
	}
    }


    public static void main( String[] args )
    {
	try
	{
	    /* interceptors are JacORB-specific as they are not yet clearly
	       and portably specified by the OMG, so we need jacorb.orb.ORB here */

	    org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init(args,null);
	    org.omg.PortableServer.POA poa = 
		org.omg.PortableServer.POAHelper.narrow(orb.resolve_initial_references("RootPOA"));
	    
	    poa.the_POAManager().activate();
	    org.omg.CORBA.Object o = poa.servant_to_reference(new Server() );

	    NamingContextExt nc = 
		NamingContextExtHelper.narrow(orb.resolve_initial_references("NameService"));

	    nc.bind( nc.to_name("Redirection.example"),o );
	    orb.run();
	} 
	catch ( Exception e )
	{
	    e.printStackTrace();
	}
    }
}


