/*
 *        JacORB - a free Java ORB
 *
 *   Copyright (C) 1997-98  Gerald Brose.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package demo.interceptors.proprietary;

/** 
 * a simple request interceptor that redirects requests to another
 * target
 */

public class RedirectClientRequestInterceptor
    implements jacorb.orb.ClientRequestInterceptor
{
    private MyServer redirection;

    /**
     * @param MyServer the target this interceptor redirects to
     */

    public RedirectClientRequestInterceptor(MyServer m)
    {
		redirection = m;
    }

    public void pre_invoke( org.omg.CORBA.Request r )
    {
		jacorb.orb.dii.Request request = (jacorb.orb.dii.Request)r;
		request.target = redirection;
    }

    public void post_invoke( org.omg.CORBA.Request r )
    {
    }

}


