package demo.any;

import org.omg.CORBA.Any;
import org.omg.CORBA.TCKind;
import jacorb.orb.*;

public class AnyServerImpl 
    extends AnyServerPOA
{
    org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init();

    public AnyServerImpl(){}

    public java.lang.String generic(Any a) 
    {
	String result = "<empty>";
	try
	{ 
	    switch( a.type().kind().value() )
	    {
	    case TCKind._tk_char:
		result = "char: " + a.extract_char();
		break;
	    case TCKind._tk_longlong:
		result = "longlong: " + a.extract_longlong();
		break;
	    case TCKind._tk_short:
		result ="Short: " + a.extract_short();
		break;
	    case TCKind._tk_double:
		result = "Double: " + a.extract_double();
		break;
	    case TCKind._tk_float:
		result = "Float: " + a.extract_float();
		break;
	    case TCKind._tk_string:
		result = "String: " + a.extract_string();
		break;
	    case TCKind._tk_struct:
		if( NodeHelper.type().equal( a.type()))
		{		
		    StringBuffer sb = new StringBuffer();
		    Node t = NodeHelper.extract( a );
		    sb.append( " " + t.name );
		    do
		    {			
			t = t.next[0];
			sb.append( " " + t.name );
		    }
		    while( t.next.length > 0 );
		    result = sb.toString();
		}	
		break;
	    case TCKind._tk_union:
		Nums n = NumsHelper.extract( a );
		switch (n.discriminator() )
                {
                case 'l' :
                    result = "Union: l " + n.l();
                    break;
                case 'f' :
		    result = "Union: f " + n.f();
                    break;
                default :
                    result = "default: " + n.s();
                }
		break;
	    case TCKind._tk_sequence:
		String[] str = stringSeqHelper.extract( a );
		result = "Sequence: " + str[0];
		break;
	    case TCKind._tk_array:
		String[] str2 = stringsHelper.extract( a );
		result = "Array: " + str2[1];
		break;
	    case TCKind._tk_objref:
		System.out.println("Objectref.");
		AnyServer s = AnyServerHelper.narrow(a.extract_Object());
		Any any = org.omg.CORBA.ORB.init().create_any();
		any.insert_string("hallo");
		result = s.generic( any );
		break;
	    default:
		System.out.println("Unknown, kind " + a.type().kind().value());
		
	    }
	} 
	catch ( Exception e )
	{
	    e.printStackTrace();
	}
	System.out.println(result);
	return result;
    }
}


