package jacorb.security.level2;

/*
 *        JacORB - a free Java ORB
 *
 *   Copyright (C) 1997-2000  Gerald Brose.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

import org.omg.SecurityLevel2.*;
import java.util.*;
import java.net.MalformedURLException;
import java.io.*;

/**
 *
 * @author Christophe Andrey, Gerald Brose
 * @version $Id: Current.java,v 1.1 2000/03/27 09:50:03 brose Exp $
 *
 */

public class Current
    extends jacorb.orb.LocalityConstrainedObject
    implements org.omg.SecurityLevel2.Current
{
    private Credentials[] own_credentials;
    private ReceivedCredentials received_credentials;
    private PrincipalAuthenticator principalAuthenticator;
    private org.omg.CORBA.ORB orb;

    public Current(org.omg.CORBA.ORB orb)
    {
	this.orb = orb;
	principalAuthenticator = new PrincipalAuthenticator(orb);

	String value = jacorb.util.Environment.getProperty("authenticate");
	if( value != null && (new Boolean(value).booleanValue()))
	{
	    authenticate();
	}
    }

    /** 
	Create the Principal Authenticator, request Credentials and set them.
	@return false If an exception was raised during the authentication
	process or if the authentication failed, true otherwise.  
    */

    private void authenticate()
    {
	
  	    CredentialsHolder coh = new CredentialsHolder();
  	    if (principalAuthenticator.authenticate(0, null, null, null, null, coh, null, null)
  		== org.omg.Security.AuthenticationStatus.SecAuthSuccess) 
  	    {
  		own_credentials = new Credentials[1];
		own_credentials[0] = (Credentials)coh.value;
  	    }
	
    }

    public org.omg.Security.SecAttribute[] get_attributes(org.omg.Security.AttributeType[] attributes)
    {
	Credentials[] source;
	org.omg.Security.SecAttribute[] tmp_result;
      
	if( own_credentials != null && received_credentials == null )
	{
	    source = own_credentials;
	}
	else if( received_credentials != null )
	{
	    source = new Credentials []{ received_credentials };
	}
	else
	{
	    System.out.println("current is returning attributes of length 0. ");
	    return new org.omg.Security.SecAttribute[0];
	}
      
	int total_length = 0;
	Vector v = new Vector();
	for( int i = 0; i < source.length; i++ )
	{
	    if (source[i] == null )
	    { 
		System.out.println("current is returning attributes of length 0. ");
		return new org.omg.Security.SecAttribute[0]; 
	    }
	    tmp_result = source[i].get_attributes(attributes);
	    total_length += tmp_result.length;
	    v.addElement(tmp_result);
	}
	org.omg.Security.SecAttribute[] result = new org.omg.Security.SecAttribute[total_length];
	int idx = 0;
	for( Enumeration e = v.elements(); e.hasMoreElements();)
	{
	    tmp_result =(org.omg.Security.SecAttribute[])e.nextElement();
	    for( int j = 0; j < tmp_result.length; j++ )
		result[idx++] = tmp_result[j];
	}
	return result;
    }
  
    public org.omg.SecurityLevel2.ReceivedCredentials received_credentials()
    {
	return received_credentials;
    }
  
    public org.omg.SecurityLevel2.Credentials[] own_credentials()
    {
	return own_credentials;
    }
  
    public void remove_own_credentials(org.omg.SecurityLevel2.Credentials credentials)
    {
	;
    }



    public org.omg.Security.SecurityFeature[] received_security_features()
    {
	return null;
    }

    public void set_credentials(org.omg.Security.CredentialType cred_type, 
				org.omg.SecurityLevel2.Credentials[] creds, 
				org.omg.SecurityLevel2.DelegationMode del)
    {
	;
    }
  
    public org.omg.SecurityLevel2.Credentials[] get_credentials(org.omg.Security.CredentialType cred_type)
    {
	return null;
    }
  
    public org.omg.CORBA.Policy get_policy(int policy_type)
    {
	return null;
    }
  
    public org.omg.Security.MechandOptions[] supported_mechanisms()
    {
	return null;
    }


    public org.omg.Security.SecurityMechanismData[] get_security_mechanisms(org.omg.CORBA.Object obj_ref)
    {
	return null;
    }


    public org.omg.SecurityLevel2.RequiredRights required_rights_object()
    {
	return null;
    }
  
    public org.omg.SecurityLevel2.PrincipalAuthenticator principal_authenticator()
    {
	return principalAuthenticator;
    }
  
    public org.omg.SecurityLevel2.AccessDecision access_decision()
    {
	return null;
    }
  
    public org.omg.SecurityLevel2.AuditDecision audit_decision()
    {
	return null;
    }
  
  
    public org.omg.SecurityLevel2.QOPPolicy create_qop_policy(org.omg.Security.QOP qop)
    {
	return null;
    }
  
    public org.omg.SecurityLevel2.MechanismPolicy create_mechanism_policy(java.lang.String[] mechanisms)
    {
	return null;
    }
  
    public org.omg.SecurityLevel2.InvocationCredentialsPolicy create_invoc_creds_policy( org.omg.SecurityLevel2.Credentials[] creds)
    {
	return null;
    }
  
}



