package jacorb.security;

import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.Vector;
import java.security.Principal;

import iaik.security.ssl.*;

/**
 * @author Andr Benvenuti ( bnv ), UGFU, Generalstab, Bern
 * @created 04.11.99
 */

/**
 * SSL server.trust decider is a call back class; it decides if the peer's certificated
 * is to be accepted.
 * the client must send a certificate.
 * the client cert chain must lead to a trusted root.
 */
public class ORBSSLServerTrustDecider implements ServerTrustDecider {

  private final static boolean DEBUG = false;

  public ORBSSLServerTrustDecider () {
  }

  /*
   * Decides if the certificate chain presented by the client is
   * trusted according to the current configuration.
   */
  public boolean isTrustedPeer ( SSLCertificate certificate ) {

    if ( DEBUG ) {
      System.out.println( "ServerTrustDecider.isTrustedPeer(..) " );
    }

    if ( certificate == null ) {
      if ( DEBUG )
        System.out.println ( "Client didn't send a certificate. "
                           + "Connection refused."
                           );
      return false;
    }
    X509Certificate[] certificate_chain = certificate.getCertificateChain();
    if ( certificate_chain == null ) {
      if ( DEBUG )
        System.out.println ( "Client didn't send a certificate "
                           + "chain. Connection refused."
                           );
      return false;
    }

    if ( CertificatesManager.verifyCertificateChain ( certificate_chain )) {
      if ( DEBUG ) {
        System.out.println ( "Certificate has trusted root. "
                           + "Connection accepted."
                           );
      }
      return true;
    }
    else {
      if ( DEBUG )
        System.out.println ( "Certificate has NO trusted root."
                           + "Connection refused."
                           );
      return false;
    }
  }
}
