package jacorb.orb.standardInterceptors;

import org.omg.PortableInterceptor.*;
import org.omg.IOP.*;
import jacorb.orb.*;
/**
 * This interceptor creates an ssl TaggedComponent
 *
 * @author Nicolas Noffke
 * @version $Id: SSLComponentInterceptor.java,v 1.1 2000/03/30 12:19:43 noffke Exp $
 */

public class SSLComponentInterceptor extends LocalityConstrainedObject
  implements IORInterceptor{

  private static final boolean endian_mode = false;
  private ORB orb = null;

  public SSLComponentInterceptor(ORB orb) {
    this.orb = orb;
  }
  
  public String name(){
    return "SSLComponentCreator";
  }

  // implementation of org.omg.PortableInterceptor.IORInterceptorOperations interface
  /**
   * Builds an ssl TaggedComponent.
   * Was formerly: ORB.makeSSLComponent()
   */
  public void establish_components(IORInfo info) {
    if( jacorb.util.Environment.supportSSL()){
      org.omg.IIOP.Version v = new org.omg.IIOP.Version((byte) 1, (byte) 1); // bnv
      org.omg.SSLIOP.SSL ssl = new org.omg.SSLIOP.SSL ((short) 0x0066,
						       (short) 0x66,
						       (short) orb.getBasicAdapter().getSSLPort());
      if ( jacorb.util.Environment.enforceSSL() ) 
	ssl.target_requires = 0x0067;

      CDROutputStream sslDataStream = new jacorb.orb.CDROutputStream(orb);
      sslDataStream.write_boolean ( endian_mode );
      org.omg.SSLIOP.SSLHelper.write( sslDataStream, ssl );
      TaggedComponent tc = new TaggedComponent(org.omg.SSLIOP.TAG_SSL_SEC_TRANS.value,
					       sslDataStream.getBufferCopy());
      sslDataStream.close();

      info.add_ior_component_to_profile (tc, TAG_INTERNET_IOP.value);
    }
  }
} // SSLComponentInterceptor
