/*
 * Decompiled with CFR 0.152.
 */
package jacorb.idl;

import java.util.Calendar;

public final class Environment {
    private static int _verbosity;

    public static final int verbosityLevel() {
        return _verbosity;
    }

    public static final void verbosityLevel(int n) {
        _verbosity = n;
    }

    public static final void output(int n, String string) {
        if (n > _verbosity) {
            return;
        }
        System.out.println("[ " + Environment.time() + "> " + string + " ]");
    }

    public static void output(int n, String string, byte[] byArray) {
        Environment.output(n, string, byArray, byArray.length);
    }

    public static void output(int n, String string, byte[] byArray, int n2) {
        if (n > _verbosity) {
            return;
        }
        System.out.print("\nHexdump [" + string + "] len=" + n2 + "," + byArray.length);
        String string2 = "";
        int n3 = 0;
        while (n3 < n2) {
            if (n3 % 16 == 0) {
                System.out.println(string2);
                string2 = "";
            }
            string2 = String.valueOf(string2) + Environment.toAscii(byArray[n3]);
            System.out.print(Environment.toHex(byArray[n3]));
            if (n3 % 4 == 3) {
                string2 = String.valueOf(string2) + " ";
                System.out.print(" ");
            }
            ++n3;
        }
        System.out.println(string2);
    }

    public static final String toHex(byte by) {
        int n = (by & 0xFF) / 16;
        int n2 = (by & 0xFF) % 16;
        char c = (char)(n > 9 ? 65 + (n - 10) : 48 + n);
        char c2 = (char)(n2 > 9 ? 65 + (n2 - 10) : 48 + n2);
        return "" + c + c2 + " ";
    }

    public static final char toAscii(byte by) {
        if (by > 31 && by < 127) {
            return (char)by;
        }
        return '.';
    }

    public static final void output(int n, Throwable throwable) {
        if (n > _verbosity) {
            return;
        }
        System.out.println("############################ StackTrace ############################");
        throwable.printStackTrace(System.out);
        System.out.println("####################################################################");
    }

    public static final String time() {
        Calendar calendar = Calendar.getInstance();
        return String.valueOf(calendar.get(11)) + ":" + (calendar.get(12) < 10 ? "0" + calendar.get(12) : String.valueOf(calendar.get(12))) + ":" + (calendar.get(13) < 10 ? "0" + calendar.get(13) : String.valueOf(calendar.get(13)));
    }
}

