package jacorb.security.ssl;

/*
 *        JacORB - a free Java ORB
 *
 *   Copyright (C) 2000  Gerald Brose
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Remarq: This a dummy implementation for those who don;t have and/or need
 *           SSL sockets
 */

import java.util.*;

import java.security.cert.*;
import iaik.security.ssl.*;

/**
 * ChainVerifier for accepting SSL connections. First, this is just
 * instrumented to get debug output, later it will be customized to
 * accept certificates based on extensions indicating role membership
 *
 * @author Gerald Brose
 * $Id: ChainVerifier.java,v 1.5 2000/03/30 06:59:16 dedeben Exp $
 *
 */

public class ChainVerifier
    extends iaik.security.ssl.ChainVerifier
{
    private java.security.KeyStore keyStore;
    
    public ChainVerifier () 
    {
	super ();
	jacorb.util.Debug.output(4, "create my ChainVerifier" );
    }

    public ChainVerifier ( java.security.KeyStore ks ) 
    {
	this ();
	keyStore = ks;
    }

    public void addTrustedCertificate(java.security.cert.X509Certificate cert)
    {
	jacorb.util.Debug.output(4, "Adding trusted cert: " + cert.getSubjectDN().getName());
	super.addTrustedCertificate(cert);
    }

    protected boolean verifyCertificate( java.security.cert.X509Certificate cert, 
					 java.security.cert.X509Certificate issuerCert )
	throws Exception
    {
	boolean r = super.verifyCertificate( cert, issuerCert );
	jacorb.util.Debug.output(3, "Verification for " + cert.getSubjectDN().getName() + 
				 (r? " succeeded" : " failed"));
	return r;       
    }

    public boolean verifyChain(java.security.cert.X509Certificate[] chain, 
			       iaik.security.ssl.SSLTransport transport)
    {
	StringBuffer sb = new StringBuffer();
	for( int i = 0; i < chain.length; i++ )
	{
	    sb.append("cert #" + i + " subject: " + chain[i].getSubjectDN().getName() + "\n" +
		      "        issuer: " + chain[i].getIssuerDN().getName() + "\n");
	}
	jacorb.util.Debug.output(3, "Verifying chain: \n" + sb.toString());

	boolean result = false;
	if ( keyStore != null )
	{
	    result =  jacorb.security.util.CertUtils.verifyCertificateChain ( chain, keyStore );
	    jacorb.util.Debug.output(3, "Chain Verification using CertUtils " + (result? " succeeded" : " failed"));
	}
	else 
	{
	    result =  super.verifyChain( chain, transport );
	jacorb.util.Debug.output(3, "Chain Verification using standard " + (result? " succeeded" : " failed"));
	}

	return result;

    }

}



