package jacorb.orb.domain.test;  
  
import jacorb.orb.domain.*;
import java.io.*;
import org.omg.CosNaming.*;

/**
 * DomainServiceManagerTesterServer.java
 * is a server to test the domain service 
 * 
 * @author Herbert Kiefer
 * @version $Revision: 1.1 $
 */
public class DomainTesterServer
{
    final static int n= 10;
  /** if started with any arguments this program registers an instance of a
      domain server at the name service, otherwise it assumes the domain
      server is already started and registerered at the name service 
  */
    public static void main( String[] args )
    {
       org.omg.CORBA.Policy[] pols= new org.omg.CORBA.Policy[n];
       org.omg.CORBA.Object[] objs= new org.omg.CORBA.Object[n];
       org.omg.CORBA.Object o= null;
       Domain ds= null;
       boolean domainServerAlreadyStarted= true;
       if (args.length > 0) domainServerAlreadyStarted= false;
    
       org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init(args, null);
       try
	 {
	   org.omg.PortableServer.POA poa = 
	     org.omg.PortableServer.POAHelper.narrow
	     (orb.resolve_initial_references("RootPOA"));
	    	    
	   poa.the_POAManager().activate();
	   
	   TestPolicyPOA servant= null;
	   // create test policies
	   TestPolicy pol[]= new TestPolicy[n];
	   for (int k= 0; k < n; k++) 
	     {
	       /* // Variante 1
	       servant= new TestPolicyImpl(k);
	       // poa.activate_object(servant);
	       o= poa.servant_to_reference(servant);
	       pol[k]= TestPolicyHelper.narrow(o);
	       */

	       /* // Variante 2
	       pol[k]= TestPolicyHelper.narrow
		 (poa.servant_to_reference(new TestPolicyImpl(k)));
	       */
	       // Variante 3
	       pol[k]= TestPolicyHelper.narrow(poa.servant_to_reference(new TestPolicyImpl(k))) ;
	     }

	   if (! domainServerAlreadyStarted) { // start one
	     DomainFactoryImpl factoryImpl= new DomainFactoryImpl();
	     DomainFactory     factory    = 
	       DomainFactoryHelper.narrow(poa.servant_to_reference(factoryImpl));

	     // create policies
	     org.omg.CORBA.Policy policies[]= new org.omg.CORBA.Policy[1];
	     //ManagePolicy cr= (new ConflictResolutionPolicyPOATie
	     //		  ( new SimpleConflictResolutionPolicy() ))._this();
	     ManagePolicy cr= ConflictResolutionPolicyHelper.narrow
	       (poa.servant_to_reference( new ConflictResolutionPolicyPOATie
					  ( new SimpleConflictResolutionPolicy()))) ;
	     policies[0]= cr;
	     jacorb.util.Debug.output(4, "using "+cr.short_description()+ " policy as default "
				 +"domain policy which states: "+cr.long_description());

	     // use factory to get a domain service	
	     ds= factory.createDomain(null, policies, cr.policy_type(), "global domain server");

	     if (args.length > 0) 
	       { // write ior to file
		 try 
		   {
		     FileOutputStream out = new FileOutputStream(args[0]);
		     PrintWriter pw = new PrintWriter(out);
		     pw.println(orb.object_to_string(ds));
		     pw.flush();
		     out.close();
		     jacorb.util.Debug.output(2, " wrote IOR of domain server to file" + args[0]);
		   }
		 catch (IOException e) 
		   {
		     System.err.println
		       ("Unable to write IOR to file " + args[0]);
		     System.exit(1);
		   }
	       }
	     else 
	       {
		 System.out.println("domain service:");
		 System.out.println(ds);
	       }
	   }
	   NamingContextExt nc = 
	     NamingContextExtHelper.narrow(
					orb.resolve_initial_references
					("NameService"));

	   if (! domainServerAlreadyStarted) 
	     {
	       nc.bind(nc.to_name("Domain.service"), ds);
	     }

	   // bind policy objects

	   for (int k =0; k < n; k++)
	     {
	       nc.bind(nc.to_name("TestPolicy"+k+".whatever"), pol[k]);
	     }
	 } 
       catch ( Exception e )
	 {
	   e.printStackTrace();
	 }
       orb.run();
    }
}
