package jacorb.orb.domain;
/**
 * SimpleResolveConflictPolicy.java
 *
 *
 * Created: Wed Mar  8 13:33:41 2000
 *
 * @author Herbert Kiefer
 * @version $Revision: 1.1 $
 */

public class SimpleConflictResolutionPolicy extends ManagePolicyImpl
  implements ConflictResolutionPolicyOperations {
  
  public SimpleConflictResolutionPolicy() {
    super("conflict resolve");

   String desc= "This object implements the domain conflict resolving policy. The "
     +"conflict resolving policy decides which domain/policy in the case of overlapping domains"
     + " to use. This policy simply uses the first domain in the list of overlapping"
     +" domains.";
   long_description(desc);
  }

public jacorb.orb.domain.Domain resolveConflict(Domain[] overlappingDMs, 
						int overlapType)
  {
    jacorb.util.Debug.assert(1, overlappingDMs.length > 0,"SimpleConflictResolutionPolicy:"
			     +" list of overlapping domain managers is empty");
    return overlappingDMs[0];
  }

 // inherited member functions

  public int policy_type()
    { return CONFLICT_RESOLUTION_POLICY_ID.value; }

  public org.omg.CORBA.Policy copy() 
  { // the _this() call may be dangerous if orb is not set
    return ( new ConflictResolutionPolicyPOATie (new SimpleConflictResolutionPolicy()) )._this();
  }
  
} // SimpleConflictResolutionPolicy
