package jacorb.orb.domain;  
  
import jacorb.orb.domain.*;
import java.io.*;
import org.omg.CosNaming.*;


/**
 * DomainServer.java
 * starts the domain service.java
 *

 * @author Herbert Kiefer
 * @version $Revision: 1.6 $
 */
public class DomainServer
{
  private static void usage()
    {
	System.err.println
	  ("Usage: java jacorb.orb.domain.DomainServer <ior_filename>");
	System.exit(1);
    }
  public static void main( String[] args )
  {
    String ior_filename= "/home/troll/kiefer/public_html/jacorb/DS_Ref";
    if (args.length < 1 ) usage(); 
    ior_filename= args[0];
    org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init(args, null);
    jacorb.util.Debug.output(2, "starting domain server ... ");

    try
      {
	org.omg.PortableServer.POA poa = 
	  org.omg.PortableServer.POAHelper.narrow
	  (orb.resolve_initial_references("RootPOA"));
	    
	poa.the_POAManager().activate();
	Domain ds;
	org.omg.CORBA.Object o;

	DomainFactoryImpl factoryImpl= new DomainFactoryImpl();
	DomainFactory     factory    = 
	  DomainFactoryHelper.narrow(poa.servant_to_reference(factoryImpl));

	// create policies
	org.omg.CORBA.Policy policies[]= new org.omg.CORBA.Policy[1];
	//ManagePolicy cr= (new ConflictResolutionPolicyPOATie
	//		  ( new SimpleConflictResolutionPolicy() ))._this();
	ManagePolicy cr= ConflictResolutionPolicyHelper.narrow(
	  poa.servant_to_reference( new ConflictResolutionPolicyPOATie
				    ( new SimpleConflictResolutionPolicy()))) ;
	policies[0]= cr;
	jacorb.util.Debug.output(4, "using "+cr.short_description()+ " policy as default "
				 +"domain policy which states: "+cr.long_description());

	// use factory to get a domain service	
	ds= factory.createDomain(null, policies, cr.policy_type(), "global domain server");

	jacorb.util.Debug.output(2, "writing IOR of domain service to file "
				 + ior_filename);
	try 
	  {

	    FileOutputStream out = new FileOutputStream(args[0]);
	    PrintWriter pw = new PrintWriter(out);
	    pw.println(orb.object_to_string(ds));
	    pw.flush();
	    out.close();
	  }
	catch (IOException e) 
	  {
	    System.err.println("Unable to write IOR to file " + args[0]);
	    System.exit(1);
	  }
	
	NamingContextExt nc = 
	  NamingContextExtHelper.narrow(orb.resolve_initial_references
				     ("NameService"));

	nc.bind(nc.to_name("Domain.service"), ds);
	   

      } 
    catch ( Exception e )
      {
	jacorb.util.Debug.output(2, e);
      }
    jacorb.util.Debug.output(2, "startup of domain server finished.");
    orb.run();
  }
} // DomainServer


