/*
 *        JacORB - a free Java ORB
 *
 *   Copyright (C) 1997-2000  Gerald Brose.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jacorb.idl;

/**
 * @author Gerald Brose
 * @version $Id: TypeDeclaration.java,v 1.7 2000/02/24 16:28:50 brose Exp $
 */

import java.util.Vector;
import java.util.Enumeration;
import java.io.*;

class TypeDeclaration 
    extends Declaration
    implements Type
{
    protected boolean typedefd = false;

    public TypeDeclaration type_decl;

    public TypeDeclaration(int num) 
    {
	super(num);
	pack_name = "";
    }

    public Object clone()
    {
	return type_decl.clone();
    }


    public TypeDeclaration declaration()
    {
	return type_decl;
    };

    public String typeName()
    {
	return type_decl.typeName();
    }

    public String signature()
    {
	return type_decl.signature();
    }

   /**
     *	we have to be able to distinguish between explicitly typedef'd
     *	type names and anonymously defined type names
     */

    public void markTypeDefd(String alias)
    {
	type_decl.markTypeDefd(alias);
    }

    /**
     * @returns a string for an expression of type TypeCode 
     * 			that describes this type
     */

    public String getTypeCodeExpression()
    {
	return type_decl.getTypeCodeExpression();
    }

    public boolean basic()
    {
	return type_decl.basic();
    } 

    public void setPackage( String s, boolean propagate_into_included )
    {
        s = parser.pack_replace(s);
	type_decl.setPackage(s, propagate_into_included);
    }

    public void set_included(boolean i)
    {
	included = i;
	type_decl.set_included(i);
    }

    public void parse() 
	 
    {
	type_decl.parse();
    }

    public String holderName()
    {
	return type_decl.holderName();
    }

    public void print(PrintWriter ps)
    {
	type_decl.print( ps );
    }

    public String toString()
    {
	return type_decl.toString();
    }
 
    public void setEnclosingSymbol( IdlSymbol s )
    {
	if( enclosing_symbol != null && enclosing_symbol != s )
	{
	    System.err.println("was " + enclosing_symbol.getClass().getName() + " now: " + s.getClass().getName());
	    throw new RuntimeException("Compiler Error: trying to reassign container for " + name );
	}
	enclosing_symbol = s;
	type_decl.setEnclosingSymbol(s);
    }

    public String printReadExpression(String streamname)
    {
	return type_decl.printReadExpression( streamname);
    }

    public String printReadStatement(String var_name, String streamname)
    {
	return var_name + "=" + printReadExpression(streamname) + ";";
    }

    public String printWriteStatement(String var_name, String streamname)
    {
	return type_decl.printWriteStatement(var_name, streamname);
    }

}







